/*
 * Created on May 26, 2005
 * 
 * $Id: AbstractTotalContributionsPayableRule.java,v 1.3 2006/06/09 11:15:06 dec Exp $
 */
package paye.eoy.bizrules.p14.nic;

import paye.eoy.bizrules.helpers.BigDecimalUtil;
import xmldoc.DocumentError;
import bizrules.binding.ErrorBinder;

/**
 * @author Rob
 */
public abstract class AbstractTotalContributionsPayableRule extends AbstractSimpleNicRule {

    public static final String X_BOTH_LT_ZERO = "x both lt zero";

    private final String[] subcodes = { X_BOTH_LT_ZERO, DocumentError.FORMAT, DocumentError.BLANK, DocumentError.MANDATORY,
            DocumentError.MAXVALUE };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    public AbstractTotalContributionsPayableRule() {
        setRuleName("TotalContributionsPayableRule");
    }

    abstract protected void processLocalRule();

    public final void processRule() {
        processLocalRule();

        // if the catagory is X it the value must equal zero
        if (getNiCategory().equals("X") && getBoth().compareTo(BigDecimalUtil.ZERO) != 0) {
            raiseError(X_BOTH_LT_ZERO, getBoth());
        }
    }

    @Override
    protected void initializeLocalValueBindings() {
        // do nothing
    }

    @Override
    public void localReset() {
        // do nothing
    }

    @Override
    protected void initializeErrorBindings() {
        final ErrorBinder binder = getErrorBinder();
        binder.add("/IRenvelope/EndOfYearReturn/P14/NICs/Both", "handleError");
        binder.add("/IRenvelope/EndOfYearReturn/P14Amended/NICs/Both", "handleError");
    }
}
