/*
 * Created on May 26, 2005
 * 
 * $Id: EmployeesContributionsPayableRule.java,v 1.3 2006/06/09 11:15:06 dec Exp $
 *  
 */
package paye.eoy.bizrules.p14.nic;

import paye.eoy.bizrules.helpers.BigDecimalUtil;
import xmldoc.DocumentError;
import bizrules.binding.ErrorBinder;

/**
 * @author Rob
 */
public abstract class EmployeesContributionsPayableRule extends AbstractSimpleNicRule {

    public static final String MUST_BE_ZERO_FOR_TABLE_CODE = "must be zero for table code";

    private final String[] subcodes = { MUST_BE_ZERO_FOR_TABLE_CODE, DocumentError.FORMAT, DocumentError.MINVALUE,
            DocumentError.MAXVALUE, DocumentError.BLANK, DocumentError.MANDATORY };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    public EmployeesContributionsPayableRule() {
        setRuleName("EmployeesContributionsPayableRule");
    }

    public final void processRule() {
        // the category must be zero for certain categories.
        if (getNiCategory().length() > 0 && getNICategoriesForWhicValueMustBeZero().indexOf(getNiCategory()) != -1
                && getEmp().compareTo(BigDecimalUtil.ZERO) != 0) {
            raiseError(MUST_BE_ZERO_FOR_TABLE_CODE, getEmp());
        }
    }

    protected abstract String getNICategoriesForWhicValueMustBeZero();

    @Override
    protected final void initializeLocalValueBindings() {
        // do nothing
    }

    @Override
    protected void initializeErrorBindings() {
        final ErrorBinder binder = getErrorBinder();
        binder.add("/IRenvelope/EndOfYearReturn/P14/NICs/Emp", "handleError");
        binder.add("/IRenvelope/EndOfYearReturn/P14Amended/NICs/Emp", "handleError");
    }

    @Override
    public final void localReset() {
        // do nothing
    }
}
