/*
 * Created on May 25, 2005
 *
 * $Id: NICategoryCountRule.java,v 1.5 2006/08/10 15:19:16 dec Exp $
 */
package paye.eoy.bizrules.p14.nic;

import paye.eoy.bizrules.p14.AbstractP14BusinessRule;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.Attribute;
import xmldoc.DocumentError;
import bizrules.binding.ErrorBinder;

/**
 * @author Rob
 * 
 */
public class NICategoryCountRule extends AbstractP14BusinessRule {

    public static final String NO_NICS = "no nics";

    public static final String TOO_MANY = "too many";

    private final String[] subcodes = { TOO_MANY, NO_NICS };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    public NICategoryCountRule() {
        setRuleName("NICategoryRule");
    }

    private int numberOfNics;

    public void setNICs(final Attribute[] attribute) {
        numberOfNics++;
    }

    @Override
    protected void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/NICs", "NICs");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/NICs", "NICs");
    }

    public void processRule() {
        if (numberOfNics < 1) {
            raiseError(NO_NICS);
        } else if (numberOfNics > 4) {
            raiseError(TOO_MANY, Integer.toString(numberOfNics));
        }
    }

    @Override
    protected String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/P14Amended", "/IRenvelope/EndOfYearReturn/P14" };
    }

    @Override
    protected ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected void initializeEventBindings() {
        // do nothing
    }

    @Override
    protected void reset() {
        numberOfNics = 0;
    }

    @Override
    protected void initializeErrorBindings() {
        final ErrorBinder binder = getErrorBinder();
        binder.add("/IRenvelope/EndOfYearReturn/P14/NICs", "handleError");
        binder.add("/IRenvelope/EndOfYearReturn/P14Amended/NICs", "handleError");
    }

    @Override
    public boolean handleError(final DocumentError documentError) {
        // Suppress the MANDATORY schema error. We'll trap this in the business
        // rule
        if (documentError.getSubCode().equals(DocumentError.MANDATORY)) {
            return true;
        } else {
            return false;
        }
    }
}
