/*
 * Created on May 26, 2005
 *
 * $Id: TotalContributionsPayableRuleOriginal.java,v 1.3 2006/06/09 11:15:06 dec Exp $
 */
package paye.eoy.bizrules.p14.nic;

import paye.eoy.bizrules.helpers.BigDecimalUtil;
import paye.eoy.types.ReturnType;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;

/**
 * @author Rob
 */
public class TotalContributionsPayableRuleOriginal extends AbstractSimpleNicRule {

    public static final String BOTH_LT_ZERO = "both lt zero";

    public static final String BOTH_LT_EMP = "both lt emp";

    public TotalContributionsPayableRuleOriginal() {
        setRuleName("TotalContributionsPayableRule");
    }

    private final String[] subcodes = { BOTH_LT_EMP, BOTH_LT_ZERO };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    public final void processRule() {
        if ("ABJRTQ".indexOf(getNiCategory()) != -1 && getBoth().compareTo(getEmp()) < 0) {
            raiseError(BOTH_LT_EMP, getBoth());
        }

        if ("ABCJQRTW".indexOf(getNiCategory()) != -1 && getBoth().compareTo(BigDecimalUtil.ZERO) < 0) {
            raiseError(BOTH_LT_ZERO, getBoth());
        }
    }

    @Override
    protected final ReturnType[] getActiveReturnTypes() {
        return new ReturnType[] { ReturnType.ORIGINAL };
    }

    @Override
    protected final ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected void initializeLocalValueBindings() {
        // do nothing
    }

    @Override
    protected void localReset() {
        // do nothing
    }

}
