package paye.eoy.bizrules.p14.nino;

public abstract class NINOChecker {
    protected String prefix = "";
    protected String middle = "";
    protected String suffix = "";

    public NINOChecker(String nino) {
        if (nino.length() >= 8) {
            middle = nino.substring(2, 8);
        }
        if (nino.length() >= 1) {
            prefix = nino.substring(0, 2);
        }
        if (nino.length() == 9) {
            suffix = nino.substring(8, 9);
        }
    }

    abstract boolean validPrefix();

    abstract boolean alphaPrefix();

    abstract boolean validMiddlePart();

    abstract boolean validSuffix();
}
