/*
 * Created on May 1, 2005
 * 
 * $Id: NINOChecker.java,v 1.1 2006/04/08 09:26:25 dec Exp $
 */
package paye.eoy.bizrules.p14.nino;

import java.util.HashSet;
import java.util.Set;

/**
 * @author doug
 * @since May 1, 2005
 */
public class NINOCheckerA extends NINOChecker {
    public static final String ValidSuffixesB = "ABCD ";

    public NINOCheckerA(final String nino) {
        super(nino);
    }

    private static Set<String> validPrefixes = new HashSet<String>();

    public static final String[] validPrefixTableCommon = {"AA", "AB", "AE", "AH", "AK", "AL", "AM", "AP", "AR", "AS", "AT", "AW",
            "AX", "AY", "AZ", "BA", "BB", "BE", "BH", "BK", "BL", "BM", "BT", "CA", "CB", "CE", "CH", "CK", "CL", "CR", "EA", "EB",
            "EE", "EH", "EK", "EL", "EM", "EP", "ER", "ES", "ET", "EW", "EX", "EY", "EZ", "GY", "HA", "HB", "HE", "HH", "HK", "HL",
            "HM", "HP", "HR", "HS", "HT", "HW", "HX", "HY", "HZ", "JA", "JB", "JC", "JE", "JG", "JH", "JJ", "JK", "JL", "JM", "JN",
            "JP", "JR", "JS", "JT", "JW", "JX", "JY", "JZ", "KA", "KB", "KE", "KH", "KK", "KL", "KM", "KP", "KR", "KS", "KT", "KW",
            "KX", "KY", "KZ", "LA", "LB", "LE", "LH", "LK", "LL", "LM", "LP", "LR", "LS", "LT", "LW", "LX", "LY", "LZ", "MA", "MW",
            "MX", "NA", "NB", "NE", "NH", "NL", "NM", "NP", "NR", "NS", "NW", "NX", "NY", "NZ", "OA", "OB", "OE", "OH", "OK", "OL",
            "OM", "OP", "OR", "OS", "OX", "PA", "PB", "PC", "PE", "PG", "PH", "PK", "PJ", "PW", "PX", "PY", "RA", "RB", "RE", "RH",
            "RK", "RM", "RP", "RR", "RS", "RT", "RW", "RX", "RY", "RZ", "SA", "SE", "SB", "SC", "SM", "SW", "TA", "TB", "TE", "TH",
            "TK", "TL", "TM", "TP", "TR", "TS", "TT", "TW", "TX", "TY", "TZ", "WA", "WB", "WE", "WK", "WL", "WM", "WP", "YA", "YB",
            "YE", "YH", "YK", "YL", "YM", "YP", "YR", "YS", "YT", "YW", "YX", "YY", "YZ", "ZA", "ZB", "ZE", "ZH", "ZK", "ZL", "ZM",
            "ZP", "ZR", "ZS", "ZT", "ZW", "ZX", "ZY",
            // "Forthcoming", meaning support them from now!
            "PL", "PM", "PN", "PP", "PR", "PS", "PT", "SG", "SH", "SJ", "SK", "SL", "SN", "SP", "SR", "SS", "ST", "SX", "SY", "SZ"};

    static {
        for (final String element : validPrefixTableCommon) {
            validPrefixes.add(element);
        }
    }

    public boolean validPrefix() {
        return validPrefixes.contains(prefix);
    }

    public boolean alphaPrefix() {
        boolean isAlpha = true;
        for (int i = 0; i < prefix.length(); i++) {
            if (!"ABCDEFGHIJKLMNOPQRSTUVWXYZ".contains(prefix.substring(i, i + 1))) {
                isAlpha = false;
                break;
            }
        }
        return isAlpha;
    }

    public boolean validMiddlePart() {
        boolean result = true;

        for (int i = 0; i < middle.length(); i++) {
            if ("0123456789".indexOf(middle.charAt(i)) == -1) { //$NON-NLS-1$
                result = false;
                break;
            }
        }
        return result;
    }

    public boolean validSuffix() {
        return ValidSuffixesB.contains(suffix);
    }
}
