/*
 * Created on May 1, 2005
 * 
 * $Id: NINOChecker.java,v 1.1 2006/04/08 09:26:25 dec Exp $
 */
package paye.eoy.bizrules.p14.nino;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * From the 1617 business rules v4:
 * Characters D, F, I, Q, U and V are not used as either the first or second letter of a NINO Prefix
 * The letter O is not used as the second letter of a Prefix
 * Prefixes BG, GB, KN, NK, NT, TN and ZZ are not to be used
 */
public class NINOCheckerB extends NINOChecker {

    static final String invalidPrefixFirstLetters = "DFIQUV";
    static final String invalidPrefixSecondLetters = invalidPrefixFirstLetters + "O";

    static final String[] invalidPrefixArray = {"BG", "GB", "KN", "NK", "NT", "TN", "ZZ"};
    static List<String> invalidPrefixes = new ArrayList<>();

    static {
        Collections.addAll(invalidPrefixes, invalidPrefixArray);
    }

    public static final String ValidSuffixesB = "ABCD ";

    public NINOCheckerB(final String nino) {
        super(nino);
    }

    public boolean validPrefix() {
        if (invalidPrefixFirstLetters.contains(prefix.substring(0, 1))) return false;
        else if (invalidPrefixSecondLetters.contains(prefix.substring(1, 2))) return false;
        else if (invalidPrefixes.contains(prefix)) return false;
        else return true;
    }

    public boolean alphaPrefix() {
        boolean isAlpha = true;
        for (int i = 0; i < prefix.length(); i++) {
            if (!"ABCDEFGHIJKLMNOPQRSTUVWXYZ".contains(prefix.substring(i, i + 1))) {
                isAlpha = false;
                break;
            }
        }
        return isAlpha;
    }

    public boolean validMiddlePart() {
        boolean result = true;

        for (int i = 0; i < middle.length(); i++) {
            if ("0123456789".indexOf(middle.charAt(i)) == -1) { //$NON-NLS-1$
                result = false;
                break;
            }
        }
        return result;
    }

    public boolean validSuffix() {
        return ValidSuffixesB.contains(suffix);
    }
}
