/*
 * Created on 06-Jan-2006
 *
 * $Id: AbstractTotalContributions.java,v 1.2 2006/04/12 15:05:44 dec Exp $
 */
package paye.eoy.bizrules.p14.parttotals;

import hmrc.bizrules.QualityStage;
import paye.eoy.bizrules.p14.nic.AbstractNicTotal;
import paye.eoy.types.SubmissionType;

/**
 * $Id: AbstractTotalContributions.java,v 1.2 2006/04/12 15:05:44 dec Exp $
 */
public abstract class AbstractTotalContributions extends AbstractNicTotal {

    public static final String BAD_TOTAL = "bad total";

    public AbstractTotalContributions() {
        setRuleName("TotalContributionsRule");
    }

    @Override
    protected void initializeSuppliedTotalBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/PartTotals/TotalContributions", "suppliedTotal");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/PartTotalsAmended/TotalContributions", "suppliedTotal");
    }

    @Override
    protected final String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/PartTotals/TotalContributions",
                "/IRenvelope/EndOfYearReturn/PartTotalsAmended/TotalContributions" };
    }

    @Override
    protected final SubmissionType[] getActiveSubmissionTypes() {
        return new SubmissionType[] { SubmissionType.P14PART };
    }

    @Override
    protected String getErrorCode() {
        return BAD_TOTAL;
    }

    @Override
    protected QualityStage getQualityStage() {
        return QualityStage.QS2;
    }

    @Override
    protected void initializeErrorBindings() {
        getErrorBinder().add("/IRenvelope/EndOfYearReturn/PartTotals/TotalContributions", "handleError");
        getErrorBinder().add("/IRenvelope/EndOfYearReturn/PartTotalsAmended/TotalContributions", "handleError");
    }

}
