/*
 * Created on 30-May-2005
 * 
 * $Id: P14PartTotalCountCheckRule.java,v 1.1 2006/04/08 09:26:25 dec Exp $
 *  
 */
package paye.eoy.bizrules.p14.parttotals;

import paye.eoy.bizrules.p14.AbstractP14CountCountCheck;
import paye.eoy.types.ReturnType;
import paye.eoy.types.SubmissionType;
import xmldoc.DocumentError;
import bizrules.binding.ErrorBinder;
import bizrules.binding.ValueBinder;

public class P14PartTotalCountCheckRule extends AbstractP14CountCountCheck {

    private final String[] subcodes = { DocumentError.MINVALUE, DocumentError.FORMAT, DocumentError.BLANK };

    @Override
    protected SubmissionType[] getActiveSubmissionTypes() {
        return new SubmissionType[] { SubmissionType.P14PART };
    }

    @Override
    public String[] getSubcodes() {
        final String[] array1 = super.getSubcodes();
        final String[] array2 = subcodes;

        return combine(array1, array2);
    }

    @Override
    protected void initializeValueBindings() {
        super.initializeValueBindings();
        final ValueBinder binder = getValueBinder();
        binder.add("/IRenvelope/EndOfYearReturn/PartTotals/P14Count", "P14Count");
        binder.add("/IRenvelope/EndOfYearReturn/PartTotalsAmended/P14Count", "P14Count");
    }

    @Override
    protected void doRuleChecks(final String value) {
        // do nothing
    }

    @Override
    protected final ReturnType[] getActiveReturnTypes() {
        return new ReturnType[] { ReturnType.ORIGINAL, ReturnType.AMENDED };
    }

    @Override
    protected void initializeErrorBindings() {
        final ErrorBinder binder = getErrorBinder();
        binder.add("/IRenvelope/EndOfYearReturn/PartTotals/P14Count", "handleError");
        binder.add("/IRenvelope/EndOfYearReturn/PartTotalsAmended/P14Count", "handleError");
    }
}
