/*
 * Created on Jul 6, 2005
 * 
 * $Id: SubtotalsRequiredRule.java,v 1.3 2006/05/26 10:45:42 dec Exp $
 */
package paye.eoy.bizrules.p14.parttotals;

import paye.eoy.bizrules.AbstractPAYEBusinessRule;
import paye.eoy.types.SubmissionType;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import bizrules.registry.DocumentEventDetail;

/**
 * @author Rob
 */
public final class SubtotalsRequiredRule extends AbstractPAYEBusinessRule {

    public static final String HAS_PART_TOTALS = "has part totals";

    private boolean hasPartTotals;

    private final String[] subcodes = { HAS_PART_TOTALS };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    public SubtotalsRequiredRule() {
        setRuleName("SubmissionTypeRule");
    }

    public void processRule() {
        if (hasPartTotals) {
            raiseError(HAS_PART_TOTALS);
        }
    }

    public void onPartTotals(final DocumentEventDetail detail) {
        hasPartTotals = true;
    }

    @Override
    protected String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn" };
    }

    @Override
    protected SubmissionType[] getActiveSubmissionTypes() {
        return new SubmissionType[] { SubmissionType.COMPLETE };
    }

    @Override
    protected ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected void initializeEventBindings() {
        getEventBinder().add("/IRenvelope/EndOfYearReturn/PartTotals", "onPartTotals");
        getEventBinder().add("/IRenvelope/EndOfYearReturn/PartTotalsAmended", "onPartTotals");
    }

    @Override
    protected void initializeValueBindings() {
        // do nothing
    }

}
