package paye.eoy.bizrules.p14.parttotals;

import paye.eoy.bizrules.qs3.AbstractSimpleTotalRule;
import paye.eoy.types.SubmissionType;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;

/**
 * @author Doug
 * @since 15/7/2010
 */
public class TotalASPPRule extends AbstractSimpleTotalRule {

    public static final String FORMAT = "format";

    @Override
    protected final String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/PartTotalsAmended/TotalASPP",
                "/IRenvelope/EndOfYearReturn/PartTotals/TotalASPP" };
    }

    @Override
    protected void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/ASPP", "value");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/ASPP", "value");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/PartTotalsAmended/TotalASPP", "suppliedTotal");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/PartTotals/TotalASPP", "suppliedTotal");
    }

    @Override
    protected SubmissionType[] getActiveSubmissionTypes() {
        return new SubmissionType[] { SubmissionType.P14PART };
    }

    @Override
    protected ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected void initializeErrorBindings() {
        getErrorBinder().add("/IRenvelope/EndOfYearReturn/PartTotals/TotalASPP", "handleError");
        getErrorBinder().add("/IRenvelope/EndOfYearReturn/PartTotalsAmended/TotalASPP", "handleError");
    }
}
