/*
 * Created on 30-May-2005
 * 
 * $Id: TotalSPPRule.java,v 1.1 2006/04/08 09:26:25 dec Exp $
 *  
 */
package paye.eoy.bizrules.p14.parttotals;

import paye.eoy.bizrules.qs3.AbstractSimpleTotalRule;
import paye.eoy.types.SubmissionType;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;

/**
 * @author Toshiba
 */
public class TotalOSPPRule extends AbstractSimpleTotalRule {

    public static final String FORMAT = "format";

    @Override
    protected final String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/PartTotalsAmended/TotalOSPP",
                "/IRenvelope/EndOfYearReturn/PartTotals/TotalOSPP" };
    }

    @Override
    protected void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/OSPP", "value");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/OSPP", "value");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/PartTotalsAmended/TotalOSPP", "suppliedTotal");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/PartTotals/TotalOSPP", "suppliedTotal");
    }

    @Override
    protected SubmissionType[] getActiveSubmissionTypes() {
        return new SubmissionType[] { SubmissionType.P14PART };
    }

    @Override
    protected ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected void initializeErrorBindings() {
        getErrorBinder().add("/IRenvelope/EndOfYearReturn/PartTotals/TotalOSPP", "handleError");
        getErrorBinder().add("/IRenvelope/EndOfYearReturn/PartTotalsAmended/TotalOSPP", "handleError");
    }
}
