/*
 * Created on 30-May-2005
 *
 * $Id: TotalSAPRule.java,v 1.1 2006/04/08 09:26:25 dec Exp $
 */
package paye.eoy.bizrules.p14.parttotals;

import paye.eoy.bizrules.qs3.AbstractSimpleTotalRule;
import paye.eoy.types.SubmissionType;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;

/**
 * 
 */
public class TotalSAPRule extends AbstractSimpleTotalRule {

    @Override
    protected final String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/PartTotalsAmended/TotalSAP",
                "/IRenvelope/EndOfYearReturn/PartTotals/TotalSAP" };
    }

    @Override
    protected void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/SAP", "value");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/SAP", "value");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/PartTotalsAmended/TotalSAP", "suppliedTotal");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/PartTotals/TotalSAP", "suppliedTotal");
    }

    @Override
    protected SubmissionType[] getActiveSubmissionTypes() {
        return new SubmissionType[] { SubmissionType.P14PART };
    }

    @Override
    protected ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected void initializeErrorBindings() {
        getErrorBinder().add("/IRenvelope/EndOfYearReturn/PartTotals/TotalSAP", "handleError");
        getErrorBinder().add("/IRenvelope/EndOfYearReturn/PartTotalsAmended/TotalSAP", "handleError");
    }

}
