/*
 * Created on 30-May-2005
 *
 * $Id: TotalSSPRule.java,v 1.1 2006/04/08 09:26:25 dec Exp $
 * 
 */
package paye.eoy.bizrules.p14.parttotals;

import paye.eoy.bizrules.qs3.AbstractSimpleTotalRule;
import paye.eoy.types.SubmissionType;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;

/**
 * @author Toshiba
 */
public class TotalSSPRule extends AbstractSimpleTotalRule {

    @Override
    protected final String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/PartTotalsAmended/TotalSSP",
                "/IRenvelope/EndOfYearReturn/PartTotals/TotalSSP" };
    }

    @Override
    protected void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/SSP", "value");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/SSP", "value");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/PartTotalsAmended/TotalSSP", "suppliedTotal");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/PartTotals/TotalSSP", "suppliedTotal");
    }

    @Override
    protected SubmissionType[] getActiveSubmissionTypes() {
        return new SubmissionType[] { SubmissionType.P14PART };
    }

    @Override
    protected ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected void initializeErrorBindings() {
        getErrorBinder().add("/IRenvelope/EndOfYearReturn/PartTotals/TotalSSP", "handleError");
        getErrorBinder().add("/IRenvelope/EndOfYearReturn/PartTotalsAmended/TotalSSP", "handleError");
    }

}
