/*
 * Created on 30-May-2005
 *
 * $Id: TotalTaxInThisEmpRule.java,v 1.2 2006/04/12 15:05:44 dec Exp $
 * 
 */
package paye.eoy.bizrules.p14.parttotals;

import paye.eoy.bizrules.qs3.AbstractTotalTaxInThisEmpRule;
import paye.eoy.types.SubmissionType;

/**
 * @author Toshiba
 */
public class TotalTaxInThisEmpRule extends AbstractTotalTaxInThisEmpRule {
    private static final String ORIGINAL_XPATH = "/IRenvelope/EndOfYearReturn/PartTotals/TotalTax";

    private static final String AMENDED_XPATH = "/IRenvelope/EndOfYearReturn/PartTotalsAmended/TotalTax";

    @Override
    protected void initializeSuppliedTotalBindings() {
        getValueBinder().add(ORIGINAL_XPATH, "suppliedTotal");
        getValueBinder().add(AMENDED_XPATH, "suppliedTotal");

        getErrorBinder().add(ORIGINAL_XPATH, "handleError");
        getErrorBinder().add(AMENDED_XPATH, "handleError");
    }

    @Override
    protected String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/PartTotalsAmended/TotalTax",
                "/IRenvelope/EndOfYearReturn/PartTotals/TotalTax" };
    }

    @Override
    protected SubmissionType[] getActiveSubmissionTypes() {
        return new SubmissionType[] { SubmissionType.P14PART };
    }

}
