/*
 * Created on May 27, 2005
 *
 * $Id: TaxInPrevEmpRuleOriginal.java,v 1.3 2006/06/09 11:15:06 dec Exp $
 * 
 */
package paye.eoy.bizrules.p14.payandtax;

import java.math.BigDecimal;

import paye.eoy.bizrules.helpers.BigDecimalUtil;
import paye.eoy.bizrules.p14.AbstractP14BusinessRule;
import paye.eoy.types.ReturnType;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

/**
 * @author Rob
 */
public final class TaxInPrevEmpRuleOriginal extends AbstractP14BusinessRule {

    public static final String TAX_GT_TAXABLE_PAY = "tax gt taxable pay";

    public static final String TAXABLE_PAY_LT_TAX = "taxable pay lt tax";

    private boolean taxablePayError;

    public TaxInPrevEmpRuleOriginal() {
        setRuleName("TaxInPrevEmpRule");
    }

    private BigDecimal taxablePay;

    private BigDecimal tax;

    private final String[] subcodes = { TAX_GT_TAXABLE_PAY, TAXABLE_PAY_LT_TAX, DocumentError.FORMAT,
            DocumentError.MINVALUE, DocumentError.MAXVALUE, DocumentError.BLANK, DocumentError.MANDATORY };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    public void setTax(final String tax) {
        this.tax = BigDecimalUtil.toBigDecimal(tax);
    }

    public void setTaxablePay(final String taxablePayNumeric) {
        this.taxablePay = BigDecimalUtil.toBigDecimal(taxablePayNumeric);
    }

    public void processRule() {
        if (tax.compareTo(taxablePay) > 0) {
            raiseError(TAX_GT_TAXABLE_PAY, tax);

            //
            // according to the spec, we also have to raise this second error -
            // which we do iff there was no equivalent schema error
            //
            // this second error is actually equivalent to the first one, but
            // just stated around the other way (ie. a > b and b < a, both of
            // which there are different errors for)
            //
            // yep, this is actually in the spec!
            //

            if (!taxablePayError) {
                // XXX the second error is commented out for now pending
                // clarification of the spec
                // raiseError(TAXABLE_PAY_LT_TAX, tax);
            }
        }
    }

    @Override
    protected void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/PayAndTax/PrevEmp/TaxablePay", "taxablePay");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/PayAndTax/PrevEmp/TaxablePay", "taxablePay");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/PayAndTax/PrevEmp/Tax", "tax");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/PayAndTax/PrevEmp/Tax", "tax");
    }

    @Override
    protected String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/P14", "/IRenvelope/EndOfYearReturn/P14Amended" };
    }

    @Override
    protected ReturnType[] getActiveReturnTypes() {
        return new ReturnType[] { ReturnType.ORIGINAL };
    }

    @Override
    protected ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected void reset() {
        taxablePay = BigDecimalUtil.ZERO;
        tax = BigDecimalUtil.ZERO;
        taxablePayError = false;
    }

    @Override
    protected void initializeEventBindings() {
        // do nothing
    }

    @Override
    protected void initializeErrorBindings() {
        getErrorBinder().add("/IRenvelope/EndOfYearReturn/P14/PayAndTax/PrevEmp/Tax", "handleError");
        getErrorBinder().add("/IRenvelope/EndOfYearReturn/P14/PayAndTax/PrevEmp/TaxablePay", "handleTaxablePayError");
    }

    public boolean handleTaxablePayError(final DocumentError documentError) {
        taxablePayError = true;
        return false;
    }
}
