/*
 * Created on May 27, 2005
 *
 * $Id: TaxInThisEmpRuleOriginal.java,v 1.5 2006/06/09 11:15:06 dec Exp $
 * 
 */
package paye.eoy.bizrules.p14.payandtax;

import java.math.BigDecimal;

import paye.eoy.bizrules.helpers.BigDecimalUtil;
import paye.eoy.bizrules.p14.AbstractP14BusinessRule;
import paye.eoy.types.ReturnType;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

/**
 * @author Rob
 */
public final class TaxInThisEmpRuleOriginal extends AbstractP14BusinessRule {

    public static final String MUST_BE_LT_TAX_PREV_EMP = "must be lt tax in prev emp";

    public static final String GT_PAY_THIS_EMP = "tax is gt pay in this emp";

    public static final String _6 = "6";

    private BigDecimal taxThisEmp;

    private BigDecimal taxPrevEmp;

    private BigDecimal taxablePayThisEmp;

    private final String[] subcodes = { MUST_BE_LT_TAX_PREV_EMP, GT_PAY_THIS_EMP, DocumentError.FORMAT };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    public TaxInThisEmpRuleOriginal() {
        setRuleName("TaxInThisEmpRule");
    }

    public void setTaxablePayThisEmp(final String taxablePayThisEmp) {
        this.taxablePayThisEmp = BigDecimalUtil.toBigDecimal(taxablePayThisEmp);
    }

    public void setTaxPrevEmp(final String taxPrevEmp) {
        this.taxPrevEmp = BigDecimalUtil.toBigDecimal(taxPrevEmp);
    }

    public void setTaxThisEmp(final String taxThisEmp) {
        this.taxThisEmp = BigDecimalUtil.toBigDecimal(taxThisEmp);
    }

    @Override
    protected void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/PayAndTax/ThisEmp/Tax", "taxThisEmp");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/PayAndTax/PrevEmp/Tax", "taxPrevEmp");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/PayAndTax/ThisEmp/TaxablePay", "taxablePayThisEmp");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/PayAndTax/ThisEmp/Tax", "taxThisEmp");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/PayAndTax/PrevEmp/Tax", "taxPrevEmp");
        getValueBinder()
                .add("/IRenvelope/EndOfYearReturn/P14Amended/PayAndTax/ThisEmp/TaxablePay", "taxablePayThisEmp");
    }

    public void processRule() {
        if (taxablePayThisEmp != null && taxThisEmp.compareTo(taxablePayThisEmp) > 0) {
            raiseError(GT_PAY_THIS_EMP, taxThisEmp);
        }

        if (taxThisEmp.compareTo(BigDecimalUtil.ZERO) < 0) {
            /*
             * If the tax in this employment is negative then its absolute value
             * must be less than or equal to the value of the tax in previous
             * employment value.
             */
            if (taxPrevEmp.compareTo(taxThisEmp.abs()) < 0) {
                raiseError(MUST_BE_LT_TAX_PREV_EMP, taxThisEmp);
            }
        }
    }

    @Override
    protected String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/P14", "/IRenvelope/EndOfYearReturn/P14Amended" };
    }

    @Override
    protected ReturnType[] getActiveReturnTypes() {
        return new ReturnType[] { ReturnType.ORIGINAL };
    }

    @Override
    protected ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected void initializeEventBindings() {
        // do nothing
    }

    @Override
    protected void reset() {
        taxThisEmp = BigDecimalUtil.ZERO;
        taxPrevEmp = BigDecimalUtil.ZERO;
        taxablePayThisEmp = BigDecimalUtil.ZERO;
    }

}
