package paye.eoy.bizrules.p35;

import paye.eoy.bizrules.qs3.AbstractRecoveredRuleOriginal;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;
import bizrules.binding.ErrorBinder;

/**
 * @author Doug
 * @since 15/7/2010
 */
public class ASPPRecoveredRuleOriginal extends AbstractRecoveredRuleOriginal {

    public ASPPRecoveredRuleOriginal() {
        setRuleName("ASPPRecoveredRule");
    }

    @Override
    protected void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/ASPP", "suppliedTotal");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/ASPP", "value");
    }

    @Override
    protected void initializeErrorBindings() {
        final ErrorBinder binder = getErrorBinder();
        binder.add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/ASPP", "handleError");
    }

    @Override
    protected final ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    public boolean handleError(final DocumentError documentError) {
        return super.handleError(documentError);
    }
}
