/*
 * Created on May 31, 2005
 * 
 * $Id: AbstractIncentivePaymentRule.java,v 1.2 2006/05/26 10:45:42 dec Exp $
 *  
 */
package paye.eoy.bizrules.p35;

import java.math.BigDecimal;

import paye.eoy.bizrules.AbstractPAYEBusinessRule;
import paye.eoy.bizrules.helpers.BigDecimalUtil;
import paye.eoy.types.SubmissionType;
import xmldoc.DocumentError;
import bizrules.binding.ErrorBinder;

/**
 * @author Rob
 */
public abstract class AbstractIncentivePaymentRule extends AbstractPAYEBusinessRule {

    public static final String MAX_ALLOWED = "max allowed";

    private final String[] subcodes = { MAX_ALLOWED, DocumentError.FORMAT, DocumentError.MANDATORY, DocumentError.BLANK,
            DocumentError.MINVALUE, DocumentError.MAXVALUE };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    public AbstractIncentivePaymentRule() {
        setRuleName("IncentivePaymentRule");
    }

    private BigDecimal incentivePayment = BigDecimalUtil.ZERO;

    public void setIncentivePayment(final String value) {
        incentivePayment = BigDecimalUtil.toBigDecimal(value);
    }

    @Override
    protected final void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/IncentivePayment", "incentivePayment");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/IncentivePayment", "incentivePayment");
    }

    public final void processRule() {
        if (incentivePayment.compareTo(getMaxValue()) > 0) {
            raiseError(MAX_ALLOWED);
        }
    }

    protected abstract BigDecimal getMaxValue();

    @Override
    protected final void initializeEventBindings() {
        // do nothing
    }

    @Override
    protected final SubmissionType[] getActiveSubmissionTypes() {
        return new SubmissionType[] { SubmissionType.P35PART, SubmissionType.COMPLETE };
    }

    @Override
    protected String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/IncentivePayment",
                "/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/IncentivePayment" };
    }

    @Override
    protected void initializeErrorBindings() {
        final ErrorBinder binder = getErrorBinder();
        binder.add("/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/IncentivePayment", "handleError");
        binder.add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/IncentivePayment", "handleError");
    }
}
