/*
 * Created on May 31, 2005
 * 
 * $Id: AbstractNICCompensationOnSMPRuleOriginal.java,v 1.3 2006/08/10 15:19:16 dec Exp $
 *  
 */
package paye.eoy.bizrules.p35;

import java.math.BigDecimal;

import paye.eoy.bizrules.AbstractPAYEBusinessRule;
import paye.eoy.bizrules.helpers.BigDecimalUtil;
import paye.eoy.types.ReturnType;
import paye.eoy.types.SubmissionType;
import xmldoc.DocumentError;
import bizrules.errors.MonetaryDiscrepancy;

public abstract class AbstractNICCompensationOnSMPRuleOriginal extends AbstractPAYEBusinessRule {

    public static final String GT_SMP_RECOVERED = "greater than smp recovered";

    private BigDecimal smpCompensation = BigDecimalUtil.ZERO;

    private BigDecimal smpRecovered = BigDecimalUtil.ZERO;

    private final String[] subcodes = { GT_SMP_RECOVERED, DocumentError.FORMAT, DocumentError.MINVALUE, DocumentError.MAXVALUE,
            DocumentError.MANDATORY, DocumentError.BLANK };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    public AbstractNICCompensationOnSMPRuleOriginal() {
        setRuleName("NICCompensationOnSMPRule");
    }

    @Override
    protected final void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SMPcompensation", "smpCompensation");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/SMPcompensation", "smpCompensation");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SMP", "smp");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/SMP", "smp");
    }

    public void processRule() {
        if (smpCompensation.compareTo(smpRecovered) > 0) {
            raiseQS3Error(GT_SMP_RECOVERED, new MonetaryDiscrepancy(smpCompensation, smpRecovered));
            /*
             * 04/05 has an extra error when smpRecovered is zero and
             * smpCompensation is not zero. This was dropped in 05/06 and beyond
             * (as it is really just a specific case of the other rules) so the
             * check is delegated to this method so that we can do different
             * things in different tax years.
             */
            extraZeroConstraintCheck(smpRecovered, smpCompensation);
        }
    }

    protected abstract void extraZeroConstraintCheck(BigDecimal recovered, BigDecimal compensation);

    public final void setSmp(final String sap) {
        this.smpRecovered = BigDecimalUtil.toBigDecimal(sap);
    }

    public final void setSmpCompensation(final String sapCompensation) {
        this.smpCompensation = BigDecimalUtil.toBigDecimal(sapCompensation);
    }

    @Override
    protected final SubmissionType[] getActiveSubmissionTypes() {
        return new SubmissionType[] { SubmissionType.COMPLETE };
    }

    @Override
    protected ReturnType[] getActiveReturnTypes() {
        return new ReturnType[] { ReturnType.ORIGINAL };
    }

    @Override
    protected final String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/P35/Summary/NIC", "/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC" };
    }

    @Override
    protected void initializeEventBindings() {
        // no event bindings
    }

    @Override
    protected void initializeErrorBindings() {
        getErrorBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SMPcompensation", "handleError");
    }
}
