/*
 * Created on May 31, 2005
 * 
 * $Id: AbstractNICCompensationOnSPPRuleOriginal.java,v 1.3 2006/08/10 15:19:16 dec Exp $
 *  
 */
package paye.eoy.bizrules.p35;

import java.math.BigDecimal;

import paye.eoy.bizrules.AbstractPAYEBusinessRule;
import paye.eoy.bizrules.helpers.BigDecimalUtil;
import paye.eoy.types.ReturnType;
import paye.eoy.types.SubmissionType;
import xmldoc.DocumentError;
import bizrules.errors.MonetaryDiscrepancy;

/**
 * @author Jaco
 */
public abstract class AbstractNICCompensationOnSPPRuleOriginal extends AbstractPAYEBusinessRule {

    public static final String COMP_GT_SPP = "comp gt spp";

    private BigDecimal sppCompensation = BigDecimalUtil.ZERO;

    private BigDecimal spp = BigDecimalUtil.ZERO;

    private final String[] subcodes = { COMP_GT_SPP, DocumentError.FORMAT, DocumentError.MAXVALUE, DocumentError.MINVALUE,
            DocumentError.MANDATORY, DocumentError.BLANK };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    public AbstractNICCompensationOnSPPRuleOriginal() {
        setRuleName("NICCompensationOnSPPRule");
    }

    @Override
    protected final void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SPPcompensation", "sppCompensation");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/SPPcompensation", "sppCompensation");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SPP", "spp");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/SPP", "spp");
    }

    public void processRule() {
        if (sppCompensation.compareTo(spp) > 0) {
            raiseQS3Error(COMP_GT_SPP, new MonetaryDiscrepancy(sppCompensation, spp));
            sppChecker(spp, sppCompensation);
        }
    }

    protected abstract void sppChecker(BigDecimal smp, BigDecimal smpCompensation);

    public final void setSpp(final String sap) {
        this.spp = BigDecimalUtil.toBigDecimal(sap);
    }

    public final void setSppCompensation(final String sapCompensation) {
        this.sppCompensation = BigDecimalUtil.toBigDecimal(sapCompensation);
    }

    @Override
    protected final SubmissionType[] getActiveSubmissionTypes() {
        return new SubmissionType[] { SubmissionType.COMPLETE };
    }

    @Override
    protected ReturnType[] getActiveReturnTypes() {
        return new ReturnType[] { ReturnType.ORIGINAL };
    }

    @Override
    protected final String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/P35/Summary/NIC", "/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC" };
    }

    @Override
    protected void initializeEventBindings() {
        // do nothing
    }

    @Override
    protected void initializeErrorBindings() {
        getErrorBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SPPcompensation", "handleError");
    }
}
