/*
 * Created on Jun 2, 2005
 *
 * $Id: AbstractNowPayableRule.java,v 1.3 2006/08/10 15:19:16 dec Exp $
 * 
 */
package paye.eoy.bizrules.p35;

import java.math.BigDecimal;

import paye.eoy.bizrules.AbstractPAYEBusinessRule;
import paye.eoy.bizrules.helpers.BigDecimalUtil;
import paye.eoy.types.SubmissionType;
import xmldoc.DocumentError;
import bizrules.binding.ErrorBinder;
import bizrules.errors.MonetaryDiscrepancy;

/**
 * @author Rob
 */
public abstract class AbstractNowPayableRule extends AbstractPAYEBusinessRule {

    public static final String BAD_TOTAL = "bad total";

    private String totalPayable;

    private String totalPaid;

    private String totalRemainingToPay;

    private final String[] subcodes = { BAD_TOTAL, DocumentError.FORMAT, DocumentError.MANDATORY, DocumentError.BLANK };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    public AbstractNowPayableRule() {
        setRuleName("NowPayableRule");
    }

    public void setTotalPaid(final String totalPaid) {
        this.totalPaid = totalPaid;
    }

    public void setTotalPayable(final String totalPayable) {
        this.totalPayable = totalPayable;
    }

    public void setTotalRemainingToPay(final String totalRemainingToPay) {
        this.totalRemainingToPay = totalRemainingToPay;
    }

    protected BigDecimal getTotalPayable() {
        return BigDecimalUtil.toBigDecimal(totalPayable);
    }

    protected BigDecimal getTotalRemainingToPay() {
        return BigDecimalUtil.toBigDecimal(totalRemainingToPay);
    }

    public BigDecimal getTotalPaid() {
        return BigDecimalUtil.toBigDecimal(totalPaid);
    }

    protected abstract void initializeLocalValueBindings();

    @Override
    protected final void initializeValueBindings() {

        initializeLocalValueBindings();

        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/TotalRemainingToPay", "totalRemainingToPay");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/TotalRemainingToPay",
                "totalRemainingToPay");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/TotalPayable", "totalPayable");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/TotalPayable", "totalPayable");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/TotalPaid", "totalPaid");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/TotalPaid", "totalPaid");
    }

    public void processRule() {
        final BigDecimal calculatedTotal = calculatedTotal();

        if (getTotalRemainingToPay().compareTo(calculatedTotal) != 0) {
            raiseQS3Error(BAD_TOTAL, new MonetaryDiscrepancy(calculatedTotal, getTotalRemainingToPay()));
        }
    }

    protected abstract BigDecimal calculatedTotal();

    @Override
    protected SubmissionType[] getActiveSubmissionTypes() {
        return new SubmissionType[] { SubmissionType.COMPLETE };
    }

    @Override
    protected void initializeEventBindings() {
        // do nothing
    }

    @Override
    protected String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts",
                "/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts" };
    }

    @Override
    protected void initializeErrorBindings() {
        final ErrorBinder binder = getErrorBinder();
        binder.add("/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/TotalRemainingToPay", "handleError");
        binder.add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/TotalRemainingToPay", "handleError");
    }
}
