/*
 * Created on Jun 9, 2005
 * 
 * $Id: AbstractP14RequiredIfAnsweredYesRule.java,v 1.4 2006/08/10 15:19:16 dec Exp $
 */
package paye.eoy.bizrules.p35;

import paye.eoy.bizrules.AbstractPAYEBusinessRule;
import paye.eoy.types.ReturnType;
import paye.eoy.types.SubmissionType;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.Attribute;
import xmldoc.DocumentError;
import bizrules.registry.DocumentEventDetail;

/**
 * @author Rob
 */
public abstract class AbstractP14RequiredIfAnsweredYesRule extends AbstractPAYEBusinessRule {

    public static final String IS_INC_NO_P14 = "is inc no p14";

    public static final String HAS_INC_INVALID_ANS = "has inc invalid answer";

    public static final String BLANK_INC_YES_ANS = "blank inc answered yes";

    public static final String HAS_INC_NO_ANS = "has inc answered no";

    // so the following xml
    // <.. IsIncluded="is stored in the variable isInclude">
    // is stored in the variable answer
    // </..>

    private String answer = "";

    private String isIncluded = "";

    private boolean hasP14;

    private final String[] subcodes = { IS_INC_NO_P14, HAS_INC_INVALID_ANS, BLANK_INC_YES_ANS, HAS_INC_NO_ANS, DocumentError.VALUE,
            DocumentError.BLANK, DocumentError.MANDATORY };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    protected String getIsIncluded() {
        return isIncluded;
    }

    protected boolean getHasP14() {
        return hasP14;
    }

    public final void setAnswer(final String answer) {
        this.answer = answer;
    }

    public void setAnswer(final Attribute[] attribute) {
        for (final Attribute element : attribute) {
            if ("IsIncluded".equals(element.getLocalName())) {
                this.isIncluded = element.getValue();
            }
        }
    }

    public void onP14(final DocumentEventDetail detail) {
        hasP14 = true;
    }

    public void processRule() {
        if (getReturnType() == ReturnType.ORIGINAL && getSubmissionType() == SubmissionType.COMPLETE) {
            if ("yes".equals(getIsIncluded()) && !getHasP14()) {
                raiseQS3Error(IS_INC_NO_P14);
            }
        }

        // the business rules refer to part1 and part2 these are :
        // part1 => answer
        // part2 => isIncluded

        // 104.2 / 106.2 / 108.2 if have answered yes to question then you must
        // answer question
        // 4 part2
        if ("yes".equals(answer) && "".equals(isIncluded)) {
            raiseError(BLANK_INC_YES_ANS);
        }

        if (!"".equals(isIncluded) && !"no".equals(isIncluded) && !"yes".equals(isIncluded)) {
            raiseError(HAS_INC_INVALID_ANS);
        }

        if ("no".equals(answer) && !"".equals(isIncluded)) {
            raiseError(HAS_INC_NO_ANS);
        }
    }

    @Override
    protected final String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn" };
    }

    @Override
    protected final SubmissionType[] getActiveSubmissionTypes() {
        return new SubmissionType[] { SubmissionType.COMPLETE, SubmissionType.P35PART };
    }

    @Override
    protected final ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected final void initializeEventBindings() {
        getEventBinder().add("/IRenvelope/EndOfYearReturn/P14", "onP14");
        getEventBinder().add("/IRenvelope/EndOfYearReturn/P14Amended", "onP14");
    }

}
