package paye.eoy.bizrules.p35;

import paye.eoy.bizrules.AbstractPAYEBusinessRule;
import paye.eoy.types.ReturnType;
import paye.eoy.types.SubmissionType;
import xmldoc.DocumentError;
import bizrules.binding.ErrorBinder;

public abstract class AbstractP38ADeclarationRule extends AbstractPAYEBusinessRule {

    // subcodes
    public static final String ARE_DUE = "are due";

    public static final String ARE_NOT_DUE = "are not due";

    protected static final String ARE_DUE_STRING = "are due";

    protected static final String ARE_NOT_DUE_STRING = "are not due";

    protected static final String NO_STRING = "no";

    protected static final String YES_STRING = "yes";

    private final String[] subcodes = { DocumentError.VALUE, DocumentError.MANDATORY, DocumentError.BLANK };

    protected String completedEndOfYearSummary;

    public AbstractP38ADeclarationRule() {
        setRuleName("P38ADeclarationRule");
    }

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    protected String p38ADeclaration;

    @Override
    protected String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/P35/Declarations/P38Adeclaration",
                "/IRenvelope/EndOfYearReturn/P35Amended/Declarations/P38Adeclaration" };
    }

    @Override
    protected SubmissionType[] getActiveSubmissionTypes() {
        return new SubmissionType[] { SubmissionType.P35PART, SubmissionType.COMPLETE };
    }

    @Override
    protected ReturnType[] getActiveReturnTypes() {
        return new ReturnType[] { ReturnType.ORIGINAL, ReturnType.AMENDED };
    }

    public void setCompletedEndOfYearSummary(final String completedEndOfYearSummary) {
        this.completedEndOfYearSummary = completedEndOfYearSummary;
    }

    public void setP38ADeclaration(final String declaration) {
        p38ADeclaration = declaration;
    }

    @Override
    protected void initializeEventBindings() {
        // do nothing
    }

    @Override
    protected void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/CheckList/CompletedEndOfYearSummary", "completedEndOfYearSummary");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Declarations/P38Adeclaration", "p38ADeclaration");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/CheckList/CompletedEndOfYearSummary",
                "completedEndOfYearSummary");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Declarations/P38Adeclaration", "p38ADeclaration");
    }

    @Override
    protected void initializeErrorBindings() {
        final ErrorBinder binder = getErrorBinder();
        binder.add("/IRenvelope/EndOfYearReturn/P35/Declarations/P38Adeclaration", "handleError");
        binder.add("/IRenvelope/EndOfYearReturn/P35Amended/Declarations/P38Adeclaration", "handleError");
    }

}