/*
 * Created on 07-Jan-2006
 *
 * $Id: AbstractTotalAmountPayableRule.java,v 1.4 2006/08/10 15:19:16 dec Exp $
 */
package paye.eoy.bizrules.p35;

import java.math.BigDecimal;

import paye.eoy.bizrules.AbstractPAYEBusinessRule;
import paye.eoy.bizrules.helpers.BigDecimalUtil;
import paye.eoy.types.SubmissionType;
import xmldoc.DocumentError;
import bizrules.binding.ErrorBinder;
import bizrules.errors.MonetaryDiscrepancy;

/**
 * $Id: AbstractTotalAmountPayableRule.java,v 1.4 2006/08/10 15:19:16 dec Exp $
 */
public abstract class AbstractTotalAmountPayableRule extends AbstractPAYEBusinessRule {

    public static final String BAD_TOTAL = "bad total";

    public AbstractTotalAmountPayableRule() {
        setRuleName("TotalAmountPayableRule");
    }

    private String totalPayable;

    private final String[] subcodes = { BAD_TOTAL, DocumentError.FORMAT, DocumentError.BLANK };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    public void setTotalPayable(final String value) {
        this.totalPayable = value;
    }

    protected String getTotalPayable() {
        return totalPayable;
    }

    protected abstract void initializeLocalValueBindings();

    @Override
    protected final void initializeValueBindings() {
        initializeLocalValueBindings();
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/TotalPayable", "totalPayable");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/TotalPayable", "totalPayable");
    }

    @Override
    protected final String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn" };
    }

    @Override
    protected final SubmissionType[] getActiveSubmissionTypes() {
        return new SubmissionType[] { SubmissionType.COMPLETE };
    }

    @Override
    protected void initializeEventBindings() {
        // do nothing
    }

    protected abstract BigDecimal getCalculatedTotal();

    public final void processRule() {
        final BigDecimal suppliedValue = BigDecimalUtil.toBigDecimal(getTotalPayable());
        final BigDecimal calculatedTotal = getCalculatedTotal();

        if (suppliedValue.compareTo(calculatedTotal) != 0) {
            raiseQS3Error(BAD_TOTAL, new MonetaryDiscrepancy(calculatedTotal, suppliedValue));
        }
    }

    @Override
    protected void initializeErrorBindings() {
        final ErrorBinder binder = getErrorBinder();
        binder.add("/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/TotalPayable", "handleError");
        binder.add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/TotalPayable", "handleError");
    }
}
