/*
 * Created on May 31, 2005
 * 
 * $Id: AbstractTotalTaxRule.java,v 1.3 2006/08/10 15:19:16 dec Exp $
 *  
 */
package paye.eoy.bizrules.p35;

import java.math.BigDecimal;

import paye.eoy.bizrules.AbstractPAYEBusinessRule;
import paye.eoy.bizrules.helpers.BigDecimalUtil;
import paye.eoy.types.SubmissionType;
import xmldoc.DocumentError;
import bizrules.errors.MonetaryDiscrepancy;

/**
 * @author Jaco
 */
public abstract class AbstractTotalTaxRule extends AbstractPAYEBusinessRule {

    public static final String BAD_TOTAL = "bad total";

    private String p14TaxStr = "";

    private String taxAdvanceStr = "";

    private String totalTaxStr = "";

    private final String[] subcodes = { BAD_TOTAL, DocumentError.FORMAT, DocumentError.BLANK, DocumentError.MANDATORY };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    public AbstractTotalTaxRule() {
        setRuleName("TotalTaxRule");
    }

    public void setP14Tax(final String value) {
        p14TaxStr = value;
    }

    public void setTaxAdvance(final String value) {
        taxAdvanceStr = value;
    }

    public void setTotalTax(final String value) {
        totalTaxStr = value;
    }

    @Override
    protected void initializeValueBindings() {
        initializeLocalValueBindings();
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/PAYE/TaxAdvance", "taxAdvance");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/PAYE/TaxAdvance", "taxAdvance");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/PAYE/P14Tax", "p14Tax");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/PAYE/P14Tax", "p14Tax");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/PAYE/TotalTax", "totalTax");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/PAYE/TotalTax", "totalTax");
    }

    public void processRule() {
        final BigDecimal totalTax = BigDecimalUtil.toBigDecimal(totalTaxStr);
        final BigDecimal p14Tax = BigDecimalUtil.toBigDecimal(p14TaxStr);
        final BigDecimal taxAdvance = BigDecimalUtil.toBigDecimal(taxAdvanceStr);

        final BigDecimal calculatedTotal = p14Tax.add(taxAdvance.add(additionalTaxAdvances()));

        if (totalTax.compareTo(calculatedTotal) != 0) {
            final MonetaryDiscrepancy discrepancy = new MonetaryDiscrepancy(calculatedTotal, totalTax);
            raiseQS3Error(BAD_TOTAL, discrepancy);
        }
    }

    protected abstract void initializeLocalValueBindings();

    protected abstract BigDecimal additionalTaxAdvances();

    @Override
    protected final String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/P35Amended/Summary/PAYE/TotalTax",
                "/IRenvelope/EndOfYearReturn/P35/Summary/PAYE/TotalTax" };
    }

    @Override
    protected SubmissionType[] getActiveSubmissionTypes() {
        return new SubmissionType[] { SubmissionType.COMPLETE };
    }

    @Override
    protected void initializeEventBindings() {
        // do nothing
    }

    @Override
    protected void initializeErrorBindings() {
        getErrorBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/PAYE/TotalTax", "handleError");
        getErrorBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/PAYE/TotalTax", "handleError");
    }

}
