package paye.eoy.bizrules.p35;

import paye.eoy.bizrules.AbstractPAYEBusinessRule;
import paye.eoy.types.SubmissionType;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import bizrules.registry.DocumentEventDetail;

/**
 * This rule checks that a P14 doesn't for P35Parts.
 */
public class CheckNoP14InP35PartSubmissionRule extends AbstractPAYEBusinessRule {

    public static final String _1 = "hasP14inP35";

    private boolean hasP14;

    private final String[] subcodes = { _1 };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    public void processRule() {
        if (hasP14) {
            raiseError(_1);
        }
    }

    @Override
    protected String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn" };
    }

    @Override
    protected SubmissionType[] getActiveSubmissionTypes() {
        return new SubmissionType[] { SubmissionType.P35PART };
    }

    @Override
    protected ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }

    public void onP14(final DocumentEventDetail detail) {
        hasP14 = true;
    }

    @Override
    protected void initializeEventBindings() {
        getEventBinder().add("/IRenvelope/EndOfYearReturn/P14Amended", "onP14");
        getEventBinder().add("/IRenvelope/EndOfYearReturn/P14", "onP14");
    }

    @Override
    protected void initializeValueBindings() {
        // do nothing
    }

}
