package paye.eoy.bizrules.p35;

import paye.eoy.bizrules.AbstractPAYEBusinessRule;
import paye.eoy.types.ReturnType;
import paye.eoy.types.SubmissionType;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;
import bizrules.binding.ErrorBinder;
import bizrules.binding.ValueBinder;

/**
 * @author doug
 * @since July 12, 2010
 */
public class EmployerNameRule extends AbstractPAYEBusinessRule {
    private final String[] subcodes = { DocumentError.LENGTH, DocumentError.FORMAT, FIRST_CHAR_IS_SPACE };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    public static final String FIRST_CHAR_IS_SPACE = "first character must not be a space";

    private String employerName = "";

    public void setEmployerName(final String employerName) {
        this.employerName = employerName;
    }

    public String getEmployerName() {
        return employerName;
    }

    public void processRule() {
        if (CHARACTER_SET_A.matcher(getEmployerName()).matches()) {
            if (getEmployerName().startsWith(" ")) {
                raiseError(FIRST_CHAR_IS_SPACE);
            }
        } else {
            raiseError(DocumentError.FORMAT);
        }
    }

    @Override
    protected String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/P35Amended/EmployerDetails/EmployerName",
                "/IRenvelope/EndOfYearReturn/P35/EmployerDetails/EmployerName" };
    }

    @Override
    protected SubmissionType[] getActiveSubmissionTypes() {
        return new SubmissionType[] { SubmissionType.P35PART, SubmissionType.COMPLETE };
    }

    @Override
    protected ReturnType[] getActiveReturnTypes() {
        return new ReturnType[] { ReturnType.ORIGINAL, ReturnType.AMENDED };
    }

    @Override
    protected ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected void initializeValueBindings() {
        final ValueBinder binder = getValueBinder();
        binder.add("/IRenvelope/EndOfYearReturn/P35/EmployerDetails/EmployerName", "employerName");
        binder.add("/IRenvelope/EndOfYearReturn/P35Amended/EmployerDetails/EmployerName", "employerName");
    }

    @Override
    protected void initializeErrorBindings() {
        final ErrorBinder binder = getErrorBinder();

        binder.add("/IRenvelope/EndOfYearReturn/P35/EmployerDetails/EmployerName", "handleError");
        binder.add("/IRenvelope/EndOfYearReturn/P35Amended/EmployerDetails/EmployerName", "handleError");
    }

    @Override
    public boolean handleError(final DocumentError error) {
        if (error.getSubCode().equals(DocumentError.FORMAT)) {
            /*
             * We're actually duplicating the schema format checks in
             * processRule so if we see a schema format error for the Employer
             * Name we can simply suppress it.
             */
            return true;
        } else {
            return false;
        }
    }

    @Override
    protected void initializeEventBindings() {
        // do nothing
    }

}
