/*
 * Created on January 24, 2006
 *
 * $Id: SPPRecoveredRuleOriginal.java,v 1.1 2006/04/08 09:26:25 dec Exp $
 * 
 */
package paye.eoy.bizrules.p35;

import paye.eoy.bizrules.qs3.AbstractRecoveredRuleOriginal;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import bizrules.binding.ErrorBinder;

/**
 * @author Rob
 */
public class OSPPRecoveredRuleOriginal extends AbstractRecoveredRuleOriginal {

    public OSPPRecoveredRuleOriginal() {
        setRuleName("OSPPRecoveredRule");
    }

    @Override
    protected void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/OSPP", "suppliedTotal");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/OSPP", "value");
    }

    @Override
    protected void initializeErrorBindings() {
        final ErrorBinder binder = getErrorBinder();
        binder.add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/OSPP", "handleError");
    }

    @Override
    protected final ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }
}
