/*
 * Created on Jul 8, 2005
 * 
 * $Id: P14DeclarationRule.java,v 1.3 2006/08/10 15:19:16 dec Exp $
 */
package paye.eoy.bizrules.p35;

import paye.eoy.bizrules.AbstractPAYEBusinessRule;
import paye.eoy.types.ReturnType;
import paye.eoy.types.SubmissionType;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;
import bizrules.binding.ErrorBinder;

/**
 * This rule has been reduced to just doing document error translations after
 * re-working the error mapping code.
 */
public class P14DeclarationRule extends AbstractPAYEBusinessRule {

    private final String[] subcodes = { DocumentError.VALUE, DocumentError.FORMAT, DocumentError.BLANK, DocumentError.MANDATORY };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    public void processRule() {
        // do nothing
    }

    @Override
    protected String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/P35Amended", "/IRenvelope/EndOfYearReturn/P35" };
    }

    @Override
    protected SubmissionType[] getActiveSubmissionTypes() {
        return new SubmissionType[] { SubmissionType.P35PART, SubmissionType.COMPLETE };
    }

    @Override
    protected ReturnType[] getActiveReturnTypes() {
        return new ReturnType[] { ReturnType.ORIGINAL, ReturnType.AMENDED };
    }

    @Override
    protected ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected void initializeValueBindings() {
        // no bindings
    }

    @Override
    protected void initializeEventBindings() {
        // do nothing
    }

    @Override
    protected void initializeErrorBindings() {
        final ErrorBinder binder = getErrorBinder();
        binder.add("/IRenvelope/EndOfYearReturn/P35/Declarations/P14Declaration", "handleError");
        binder.add("/IRenvelope/EndOfYearReturn/P35Amended/Declarations/P14Declaration", "handleError");
    }
}
