/*
 * Created on May 31, 2005
 *
 * $Id: P38ADeclarationRule.java,v 1.1 2006/04/08 09:26:25 dec Exp $
 */
package paye.eoy.bizrules.p35;

import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;

/**
 * @author Jaco
 */
public class P38ADeclarationRuleB extends AbstractP38ADeclarationRule {

    private final String[] subcodes = { ARE_DUE, ARE_NOT_DUE };

    @Override
    public String[] getSubcodes() {
        return combine(super.getSubcodes(), subcodes);
    }

    public void processRule() {
        if (completedEndOfYearSummary != null && p38ADeclaration != null) {
            if (completedEndOfYearSummary.equals(NO_STRING) && !p38ADeclaration.equals(ARE_DUE_STRING)) {
                raiseError(ARE_DUE, p38ADeclaration);
            } else if (completedEndOfYearSummary.equals(YES_STRING) && !p38ADeclaration.equals(ARE_NOT_DUE_STRING)) {
                raiseError(ARE_NOT_DUE, p38ADeclaration);
            }
        }
    }

    @Override
    protected ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }
}
