/*
 * Created on May 31, 2005
 *
 * $Id: TotalNICRuleComplete.java,v 1.2 2006/08/10 15:19:16 dec Exp $
 * 
 */
package paye.eoy.bizrules.p35;

import java.math.BigDecimal;

import paye.channel.SubmissionChannel;
import paye.eoy.bizrules.AbstractPAYEBusinessRule;
import paye.eoy.bizrules.helpers.BigDecimalUtil;
import paye.eoy.types.SubmissionType;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;

/**
 * Cross-check the total NIC in the P35 against the sum of the NIC values in the
 * P14s.
 */
public class TotalNICRuleP35Part extends AbstractPAYEBusinessRule {

    public static final String SHOULD_BE_ZERO = "should be zero";

    private BigDecimal totalNIC = BigDecimalUtil.ZERO;

    private long numberOfParts;

    private boolean numberOfPartsSet = false;

    private final String[] subcodes = { SHOULD_BE_ZERO };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    public TotalNICRuleP35Part() {
        setRuleName("TotalNICRule");
    }

    @Override
    protected void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/TotalNIC", "TotalNic");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/TotalNIC", "TotalNic");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/NumberOfParts", "numberOfParts");
    }

    public void setTotalNic(final String value) {
        if (!value.equals("")) {
            totalNIC = BigDecimalUtil.toBigDecimal(value);
        }
    }

    public void setNumberOfParts(final String value) {
        try {
            numberOfParts = Long.valueOf(value);
            numberOfPartsSet = true;
        } catch (final NumberFormatException ex) {
            // do nothing - bad value for field will be caught by schema
        }
    }

    @Override
    protected ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected SubmissionType[] getActiveSubmissionTypes() {
        final SubmissionType[] activeTypes = new SubmissionType[] { SubmissionType.P35PART };
        return activeTypes;
    }

    @Override
    protected String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn" };

    }

    public void processRule() {
        if (getSubmissionChannel() != SubmissionChannel.FBI) {
            if (numberOfPartsSet && numberOfParts == 0 && totalNIC.compareTo(BigDecimal.ZERO) > 0) {
                raiseError(SHOULD_BE_ZERO, totalNIC);
            }
        }
    }

    @Override
    protected void initializeEventBindings() {
        // do nothing
    }

}
