/*
 * Created on May 31, 2005
 * 
 * $Id: TotalNICSTaxAndStLoanRule.java,v 1.3 2006/08/10 15:19:16 dec Exp $
 *  
 */
package paye.eoy.bizrules.p35;

import java.math.BigDecimal;

import paye.eoy.bizrules.AbstractPAYEBusinessRule;
import paye.eoy.bizrules.helpers.BigDecimalUtil;
import paye.eoy.types.SubmissionType;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;
import bizrules.binding.ErrorBinder;
import bizrules.errors.MonetaryDiscrepancy;

/**
 * @author Rob
 */
public class TotalNICSTaxAndStLoanRule extends AbstractPAYEBusinessRule {

    public static final String BAD_TOTAL = "bad total";

    private BigDecimal totalTaxAndNIC = BigDecimalUtil.ZERO;

    private BigDecimal totalNICsTaxAndStudentLoan = BigDecimalUtil.ZERO;

    private BigDecimal studentLoan = BigDecimalUtil.ZERO;

    private final String[] subcodes = { BAD_TOTAL, DocumentError.FORMAT, DocumentError.MANDATORY, DocumentError.BLANK };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    public void processRule() {
        final BigDecimal calculatedTotal = totalTaxAndNIC.add(studentLoan);

        if (totalNICsTaxAndStudentLoan.compareTo(calculatedTotal) != 0) {
            raiseQS3Error(BAD_TOTAL, new MonetaryDiscrepancy(calculatedTotal, totalNICsTaxAndStudentLoan));
        }
    }

    @Override
    protected String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/P35", "/IRenvelope/EndOfYearReturn/P35Amended" };
    }

    @Override
    protected SubmissionType[] getActiveSubmissionTypes() {
        return new SubmissionType[] { SubmissionType.COMPLETE };
    }

    @Override
    protected final ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }

    public void setStudentLoan(final String studentLoan) {
        this.studentLoan = BigDecimalUtil.toBigDecimal(studentLoan);
    }

    public void setTotalNICsTaxAndStudentLoan(final String totalNICsTaxAndStudentLoan) {
        this.totalNICsTaxAndStudentLoan = BigDecimalUtil.toBigDecimal(totalNICsTaxAndStudentLoan);
    }

    public void setTotalTaxAndNIC(final String totalTaxAndNIC) {
        this.totalTaxAndNIC = BigDecimalUtil.toBigDecimal(totalTaxAndNIC);
    }

    @Override
    protected void initializeEventBindings() {
        // do nothing
    }

    @Override
    protected void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/TotalNICsTaxAndStudentLoan",
                "totalNICsTaxAndStudentLoan");
        getValueBinder()
                .add("/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/TotalTaxAndNIC", "totalTaxAndNIC");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/StudentLoan", "studentLoan");

        getValueBinder().add(
                "/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/TotalNICsTaxAndStudentLoan",
                "totalNICsTaxAndStudentLoan");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/TotalTaxAndNIC",
                "totalTaxAndNIC");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/StudentLoan",
                "studentLoan");
    }

    @Override
    protected void initializeErrorBindings() {
        final ErrorBinder binder = getErrorBinder();
        binder.add("/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/TotalNICsTaxAndStudentLoan", "handleError");
        binder.add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/TotalNICsTaxAndStudentLoan",
                "handleError");
    }
}
