/*
 * Created on May 31, 2005
 * 
 * $Id: TotalTaxFromP14sRule.java,v 1.2 2006/04/12 15:05:44 dec Exp $
 *  
 */
package paye.eoy.bizrules.p35;

import hmrc.bizrules.QualityStage;
import paye.eoy.bizrules.qs3.AbstractTotalTaxInThisEmpRule;
import paye.eoy.types.SubmissionType;

/**
 * 
 */
public class TotalTaxFromP14sRule extends AbstractTotalTaxInThisEmpRule {

    private static final String AMENDED_XPATH = "/IRenvelope/EndOfYearReturn/P35Amended/Summary/PAYE/P14Tax";

    private static final String ORIGINAL_XPATH = "/IRenvelope/EndOfYearReturn/P35/Summary/PAYE/P14Tax";

    @Override
    protected void initializeSuppliedTotalBindings() {
        getValueBinder().add(ORIGINAL_XPATH, "suppliedTotal");
        getValueBinder().add(AMENDED_XPATH, "suppliedTotal");

        getErrorBinder().add(ORIGINAL_XPATH, "handleError");
        getErrorBinder().add(AMENDED_XPATH, "handleError");
    }

    @Override
    protected SubmissionType[] getActiveSubmissionTypes() {
        return new SubmissionType[] { SubmissionType.COMPLETE };
    }

    @Override
    protected final String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn" };
    }

    @Override
    protected QualityStage getQualityStage() {
        return QualityStage.QS3;
    }

}
