/*
 * Created on Sep 16, 2005
 * 
 * $Id: NowPayableRule0506.java,v 1.1 2006/04/08 09:26:25 dec Exp $
 */
package paye.eoy.bizrules.p35.br0506;

import java.math.BigDecimal;

import paye.eoy.bizrules.helpers.BigDecimalUtil;
import paye.eoy.bizrules.p35.AbstractNowPayableRule;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;

/**
 * @author Rob
 */
public final class NowPayableRuleB extends AbstractNowPayableRule {

    private String incentivePayment;

    private BigDecimal getIncentivePayment() {
        return BigDecimalUtil.toBigDecimal(incentivePayment);
    }

    @Override
    protected BigDecimal calculatedTotal() {

        return getTotalPayable().subtract(getTotalPaid()).subtract(getIncentivePayment());
    }

    @Override
    protected ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected void initializeLocalValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/IncentivePayment", "incentivePayment");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/IncentivePayment", "incentivePayment");
    }

    public void setIncentivePayment(final String incentivePayment) {
        this.incentivePayment = incentivePayment;
    }

}
