/*
 * Created on Jun 2, 2005
 * 
 * $Id: TotalAmountPayableRuleB.java,v 1.2 2006/05/12 10:02:57 dec Exp $
 *  
 */
package paye.eoy.bizrules.p35.br0607;

import java.math.BigDecimal;

import paye.eoy.bizrules.helpers.BigDecimalUtil;
import paye.eoy.bizrules.p35.AbstractTotalAmountPayableRule;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;

/**
 * 
 */
public class TotalAmountPayableRuleB extends AbstractTotalAmountPayableRule {
    private String subcontractorTaxStr;

    private String combinedLessStatutoryRecoveredStr;

    public void setCombinedLessStatutoryRecovered(final String value) {
        this.combinedLessStatutoryRecoveredStr = value;
    }

    public void setSubcontractorTax(final String value) {
        this.subcontractorTaxStr = value;
    }

    @Override
    protected final void initializeLocalValueBindings() {

        // combinedLessStatutoryRecovered
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/CombinedLessStatutoryRecovered",
                "combinedLessStatutoryRecovered");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/CombinedLessStatutoryRecovered",
                "combinedLessStatutoryRecovered");

        // SubcontractorTax
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/SubcontractorTax", "subcontractorTax");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/SubcontractorTax", "subcontractorTax");
    }

    @Override
    protected BigDecimal getCalculatedTotal() {
        final BigDecimal combinedAmounts = BigDecimalUtil.toBigDecimal(combinedLessStatutoryRecoveredStr);
        final BigDecimal subcontractorTax = BigDecimalUtil.toBigDecimal(subcontractorTaxStr);

        final BigDecimal result = combinedAmounts.add(subcontractorTax);

        return result;
    }

    @Override
    protected ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }

}
