package paye.eoy.bizrules.p35.br0809;

import paye.eoy.bizrules.AbstractPAYEBusinessRule;
import paye.eoy.types.ReturnType;
import paye.eoy.types.SubmissionType;
import xmldoc.Attribute;

public abstract class AbstractECONRequiredRule extends AbstractPAYEBusinessRule {
    private final String[] subcodes = { REQUIRED };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    public static final String REQUIRED = "required";

    private boolean econRequired;

    private String econ = "";

    public AbstractECONRequiredRule() {
        setRuleName("ECONRule");
    }

    public final void setNICs(final Attribute[] attributes) {
        if (!econRequired) {
            for (final Attribute element : attributes) {
                if ("Tab".equals(element.getLocalName())) {
                    final String value = element.getValue();
                    if (value.length() == 1) {
                        if (getTableCodes().indexOf(value.charAt(0)) != -1) {
                            econRequired = true;
                        }
                    }
                }
            }
        }
    }

    protected abstract String getTableCodes();

    public void setEcon(final String econ) {
        this.econ = econ;
    }

    public final void processRule() {
        if (econRequired) {
            if ("".equals(econ)) {
                raiseError(REQUIRED, econ);
            }
        }
    }

    @Override
    protected String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn" };
    }

    @Override
    protected SubmissionType[] getActiveSubmissionTypes() {
        return new SubmissionType[] { SubmissionType.COMPLETE };
    }

    @Override
    protected ReturnType[] getActiveReturnTypes() {
        return new ReturnType[] { ReturnType.ORIGINAL };
    }

    @Override
    protected void initializeEventBindings() {
        // do nothing
    }

    @Override
    protected void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/NICs", "NICs");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/NICs", "NICs");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/EmployerDetails/ECON", "econ");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/EmployerDetails/ECON", "econ");
    }
}
