package paye.eoy.bizrules.p35.br1112;

import java.math.BigDecimal;

import paye.eoy.bizrules.AbstractPAYEBusinessRule;
import paye.eoy.bizrules.helpers.BigDecimalUtil;
import paye.eoy.types.ReturnType;
import paye.eoy.types.SubmissionType;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;
import bizrules.errors.MonetaryDiscrepancy;

public class NICCompensationOnASPPRule extends AbstractPAYEBusinessRule {

    public static final String COMP_GT_ASPP = "comp gt aspp";

    private BigDecimal asppCompensation = BigDecimalUtil.ZERO;

    private BigDecimal aspp = BigDecimalUtil.ZERO;

    private final String[] subcodes = { COMP_GT_ASPP, DocumentError.FORMAT, DocumentError.MAXVALUE,
            DocumentError.MINVALUE, DocumentError.MANDATORY, DocumentError.BLANK };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    @Override
    protected ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected final void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/ASPPcompensation", "asppCompensation");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/ASPPcompensation", "asppCompensation");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/ASPP", "aspp");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/ASPP", "aspp");
    }

    public void processRule() {
        if (asppCompensation.compareTo(aspp) > 0) {
            raiseQS3Error(COMP_GT_ASPP, new MonetaryDiscrepancy(asppCompensation, aspp));
        }
    }

    public final void setAspp(final String sap) {
        this.aspp = BigDecimalUtil.toBigDecimal(sap);
    }

    public final void setAsppCompensation(final String sapCompensation) {
        this.asppCompensation = BigDecimalUtil.toBigDecimal(sapCompensation);
    }

    @Override
    protected final SubmissionType[] getActiveSubmissionTypes() {
        return new SubmissionType[] { SubmissionType.COMPLETE };
    }

    @Override
    protected ReturnType[] getActiveReturnTypes() {
        return new ReturnType[] { ReturnType.ORIGINAL };
    }

    @Override
    protected final String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn/P35/Summary/NIC",
                "/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC" };
    }

    @Override
    protected void initializeEventBindings() {
        // do nothing
    }

    @Override
    protected void initializeErrorBindings() {
        getErrorBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/ASPPcompensation", "handleError");
    }
}
