package paye.eoy.bizrules.p35.br1112;

import bizrules.errors.MonetaryDiscrepancy;
import paye.eoy.bizrules.AbstractPAYEBusinessRule;
import paye.eoy.bizrules.helpers.BigDecimalUtil;
import paye.eoy.types.ReturnType;
import paye.eoy.types.SubmissionType;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

import java.math.BigDecimal;

public class NICCompensationOnOSPPRule extends AbstractPAYEBusinessRule {

    public static final String COMP_GT_OSPP = "comp gt ospp";

    private BigDecimal osppCompensation = BigDecimalUtil.ZERO;

    private BigDecimal ospp = BigDecimalUtil.ZERO;

    private final String[] subcodes = {COMP_GT_OSPP, DocumentError.FORMAT, DocumentError.MAXVALUE,
            DocumentError.MINVALUE, DocumentError.MANDATORY, DocumentError.BLANK};

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    @Override
    protected ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected final void initializeValueBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/OSPPcompensation", "osppCompensation");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/OSPPcompensation", "osppCompensation");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/OSPP", "ospp");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/OSPP", "ospp");
    }

    public void processRule() {
        if (osppCompensation.compareTo(ospp) > 0) {
            raiseQS3Error(COMP_GT_OSPP, new MonetaryDiscrepancy(osppCompensation, ospp));
        }
    }

    public final void setOspp(final String sap) {
        this.ospp = BigDecimalUtil.toBigDecimal(sap);
    }

    public final void setOsppCompensation(final String sapCompensation) {
        this.osppCompensation = BigDecimalUtil.toBigDecimal(sapCompensation);
    }

    @Override
    protected final SubmissionType[] getActiveSubmissionTypes() {
        return new SubmissionType[]{SubmissionType.COMPLETE};
    }

    @Override
    protected ReturnType[] getActiveReturnTypes() {
        return new ReturnType[]{ReturnType.ORIGINAL};
    }

    @Override
    protected final String[] getInvocationPoints() {
        return new String[]{"/IRenvelope/EndOfYearReturn/P35/Summary/NIC",
                "/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC"};
    }

    @Override
    protected void initializeEventBindings() {
        // do nothing
    }

    @Override
    protected void initializeErrorBindings() {
        getErrorBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/NIC/OSPPcompensation", "handleError");
    }
}
