package paye.eoy.bizrules.qs3;

import java.math.BigDecimal;

import paye.eoy.bizrules.AbstractPAYEBusinessRule;
import paye.eoy.bizrules.helpers.BigDecimalTotalizer;
import paye.eoy.bizrules.helpers.BigDecimalUtil;
import paye.eoy.types.ReturnType;
import paye.eoy.types.SubmissionType;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;
import bizrules.errors.MonetaryDiscrepancy;

/**
 * Raises an error is the calculated value ( from totalizing the values in the
 * p14's) is less than the supplied value value.
 */
public abstract class AbstractRecoveredRuleOriginal extends AbstractPAYEBusinessRule {

    public static final String BAD_TOTAL = "bad total";

    private String suppliedTotal = "";

    private final BigDecimalTotalizer totalizer = new BigDecimalTotalizer();

    private final String[] subcodes = { BAD_TOTAL, DocumentError.FORMAT, DocumentError.MAXVALUE, DocumentError.MINVALUE,
            DocumentError.MANDATORY, DocumentError.BLANK };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    public final void setSuppliedTotal(final String value) {
        suppliedTotal = value;
    }

    /**
     * adds the value to the calculated total
     */
    public final void setValue(final String value) {
        totalizer.add(value);
    }

    @Override
    protected final void initializeEventBindings() {
        // do nothing
    }

    public final void processRule() {
        final BigDecimal calculated = totalizer.getTotal();
        final BigDecimal supplied = BigDecimalUtil.toBigDecimal(suppliedTotal);

        if (calculated.compareTo(supplied) < 0) {
            raiseQS3Error(BAD_TOTAL, new MonetaryDiscrepancy(calculated, supplied));
        }
    }

    @Override
    protected final String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn" };
    }

    @Override
    protected final SubmissionType[] getActiveSubmissionTypes() {
        return new SubmissionType[] { SubmissionType.COMPLETE };
    }

    @Override
    protected final ReturnType[] getActiveReturnTypes() {
        return new ReturnType[] { ReturnType.ORIGINAL };
    }

    @Override
    protected ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }

}