package paye.eoy.bizrules.qs3;

import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;

/**
 * $Id$
 */
public abstract class AbstractStudentLoanRule extends AbstractTotalRule {

    protected abstract void initializeSuppliedTotalBindings();

    @Override
    protected final void initializeValueBindings() {
        initializeSuppliedTotalBindings();
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14/PayAndTax/ThisEmp/StLoan", "value");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P14Amended/PayAndTax/ThisEmp/StLoan", "value");
    }

    @Override
    protected final String[] getInvocationPoints() {
        return new String[] { "/IRenvelope/EndOfYearReturn" };
    }

    @Override
    protected final ActiveTaxYear[] getApplicableTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected final boolean isValueIncludeInTotal() {
        return true;
    }

}