package paye.eoy.bizrules.qs3;

import hmrc.bizrules.QualityStage;

import java.math.BigDecimal;

import paye.eoy.bizrules.AbstractPAYEBusinessRule;
import paye.eoy.bizrules.helpers.BigDecimalTotalizer;
import paye.eoy.bizrules.helpers.BigDecimalUtil;
import xmldoc.DocumentError;
import bizrules.errors.MonetaryDiscrepancy;

/**
 * 
 */
public abstract class AbstractTotalRule extends AbstractPAYEBusinessRule {

    private String suppliedTotal = "";

    private final BigDecimalTotalizer totalizer = new BigDecimalTotalizer();

    private final String[] subcodes = { getErrorCode(), DocumentError.FORMAT, DocumentError.BLANK, DocumentError.MANDATORY,
            DocumentError.MINVALUE, DocumentError.MAXVALUE };

    @Override
    public String[] getSubcodes() {
        return subcodes;
    }

    public final void setSuppliedTotal(final String value) {
        suppliedTotal = value;
    }

    /**
     * allow the implement to selectively add values to the totalizer, depending
     * for example on the NIC some values may not be added.
     */
    protected abstract boolean isValueIncludeInTotal();

    /**
     * adds the value only if it is required
     * 
     * @see isValueIncludeInTotal();
     */
    public void setValue(final String value) {
        if (isValueIncludeInTotal()) {
            totalizer.add(value);
        }
    }

    @Override
    protected void initializeEventBindings() {
        // do nothing
    }

    protected abstract String getErrorCode();

    protected abstract QualityStage getQualityStage();

    public void processRule() {
        final BigDecimal calculated = totalizer.getTotal();
        final BigDecimal supplied = BigDecimalUtil.toBigDecimal(suppliedTotal);

        if (calculated.compareTo(supplied) != 0) {
            if (getQualityStage() == QualityStage.QS3) {
                raiseQS3Error(getErrorCode(), new MonetaryDiscrepancy(calculated, supplied));
            } else {
                raiseError(getErrorCode(), new MonetaryDiscrepancy(calculated, supplied));
            }
        }
    }
}