package paye.eoy.bizrules.qs3;

import hmrc.bizrules.QualityStage;
import paye.eoy.types.SubmissionType;
import xmldoc.DocumentError;
import bizrules.binding.ErrorBinder;

/**
 * @author Jaco
 */
public class TotalStudentLoanDeductionsRule extends AbstractStudentLoanRule {

    public static final String BAD_TOTAL = "bad total";

    public static final String NON_WHOLE_AMOUNT = "non whole amount";

    private final String[] subcodes = { NON_WHOLE_AMOUNT };

    @Override
    protected void initializeSuppliedTotalBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/StudentLoan", "suppliedTotal");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/StudentLoan", "suppliedTotal");
    }

    @Override
    public String[] getSubcodes() {
        return combine(super.getSubcodes(), subcodes);
    }

    @Override
    protected SubmissionType[] getActiveSubmissionTypes() {
        return new SubmissionType[] { SubmissionType.COMPLETE };
    }

    @Override
    protected String getErrorCode() {
        return BAD_TOTAL;
    }

    @Override
    protected QualityStage getQualityStage() {
        return QualityStage.QS3;
    }

    @Override
    protected void initializeErrorBindings() {
        final ErrorBinder binder = getErrorBinder();
        binder.add("/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/StudentLoan", "handleError");
        binder.add("/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/StudentLoan", "handleError");
    }

    @Override
    public boolean handleError(final DocumentError documentError) {
        if (DocumentError.FORMAT.equals(documentError.getSubCode()) && (documentError.getValueInError() instanceof String)) {
            final String suppliedTotal = (String) documentError.getValueInError();
            // length must be greater than or equal to 4 to fit required 0.00
            // format
            if (suppliedTotal.length() >= 4) {
                try {
                    // check if number parses as a double and has exactly two
                    // decimal places with at least one digit before the decimal
                    // place
                    final int index = suppliedTotal.lastIndexOf('.');
                    if (index > 0 && index == suppliedTotal.length() - 3) {
                        Double.parseDouble(suppliedTotal);
                        if (!suppliedTotal.endsWith("00")) {
                            documentError.setSubCode(NON_WHOLE_AMOUNT);
                        }
                    }
                } catch (final NumberFormatException nfEx) {
                    ; // number format problem, treat as regular document
                    // format error
                }
            }
        }
        return super.handleError(documentError);
    }
}
