package paye.eoy.bizrules.qs3;

import hmrc.bizrules.QualityStage;
import paye.eoy.types.SubmissionType;
import bizrules.binding.ErrorBinder;

/**
 * @author Toshiba
 */
public class TotalStudentLoanRule extends AbstractStudentLoanRule {

    public static final String BAD_TOTAL = "bad total";

    @Override
    protected void initializeSuppliedTotalBindings() {
        getValueBinder().add("/IRenvelope/EndOfYearReturn/PartTotalsAmended/TotalStudentLoanDeductions", "suppliedTotal");
        getValueBinder().add("/IRenvelope/EndOfYearReturn/PartTotals/TotalStudentLoanDeductions", "suppliedTotal");
    }

    @Override
    protected SubmissionType[] getActiveSubmissionTypes() {
        return new SubmissionType[] { SubmissionType.P14PART };
    }

    @Override
    protected String getErrorCode() {
        return BAD_TOTAL;
    }

    @Override
    protected QualityStage getQualityStage() {
        return QualityStage.QS2;
    }

    @Override
    protected void initializeErrorBindings() {
        final ErrorBinder binder = getErrorBinder();
        binder.add("/IRenvelope/EndOfYearReturn/PartTotals/TotalStudentLoanDeductions", "handleError");
        binder.add("/IRenvelope/EndOfYearReturn/PartTotalsAmended/TotalStudentLoanDeductions", "handleError");
    }
}
