package paye.eoy.output.mapper;

import java.util.Collections;
import java.util.Map;
import java.util.Properties;

import paye.channel.SubmissionChannel;
import paye.multiyear.TaxYear;
import paye.tolerances.Tolerance;
import paye.tolerances.ToleranceSource;

public abstract class AbstractPAYEErrorMapper extends AbstractEOYErrorMapper implements ToleranceSource {

    @Override
    protected Properties getMessageProperties(final TaxYear taxYear) {
        return MessagePropertyFactory.getInstance(taxYear);
    }

    public Tolerance getTolerance(final TaxYear year, final SubmissionChannel channel, final String subCode) {
        Tolerance tolerance = getTolerances(year, channel).get(subCode);
        if (tolerance == null) {
            tolerance = Tolerance.TYPE_1;
        }
        return tolerance;
    }

    public ToleranceSource getToleranceSource() {
        return this;
    }

    protected Map<String, Tolerance> getTolerances(final TaxYear year, final SubmissionChannel channel) {
        return Collections.emptyMap();
    }
}
