/*
 * Created on 23-Dec-2005
 *
 * $Id: Message.java,v 1.2 2006/02/26 09:35:28 dec Exp $
 */
package paye.eoy.output.mapper;

import paye.multiyear.TaxYear;

/**
 * This is a hook into the error message tables for the eric response errors.
 * One of the elements in each response message table entry is a key into the
 * message table for the appropriate year.
 * 
 */
public final class Message {

    private Message() {
        // prevents instantiation
    }

    public static String lookupMessage(final TaxYear taxYear, final String key) {
        return MessagePropertyFactory.getInstance(taxYear).getProperty(key);
    }

}
