/*
 * Created on 23-Dec-2005
 *
 * $Id: MessagePropertyFactory.java,v 1.4 2006/03/08 17:16:23 dec Exp $
 */
package paye.eoy.output.mapper;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import paye.multiyear.TaxYear;
import paye.multiyear.TaxYearNotSupportedException;

/**
 * 
 */
public class MessagePropertyFactory {

    private static Properties globalProperties;

    private static final Map<TaxYear, Properties> PER_TAX_YEAR_PROPERTIES_MAP = new HashMap<TaxYear, Properties>();

    public static Properties getInstance(final TaxYear taxYear) {
        Properties props;
        synchronized (PER_TAX_YEAR_PROPERTIES_MAP) {
            props = PER_TAX_YEAR_PROPERTIES_MAP.get(taxYear);

            if (props == null) {
                try {
                    props = new Properties(getGlobalProperties());
                    if (taxYear != TaxYear.UNKNOWN && taxYear != TaxYear.UNSUPPORTED) {
                        props.load(Message.class.getResourceAsStream("eric-messages-" + taxYear.toString() + ".properties"));
                    }
                    PER_TAX_YEAR_PROPERTIES_MAP.put(taxYear, props);
                } catch (final IOException e) {
                    throw new TaxYearNotSupportedException(taxYear);
                } catch (final NullPointerException e) {
                    e.printStackTrace();
                    throw new TaxYearNotSupportedException(taxYear);
                }
            }
        }
        return props;
    }

    private static synchronized Properties getGlobalProperties() throws IOException {
        if (globalProperties == null) {
            final Properties props = new Properties();
            props.load(Message.class.getResourceAsStream("eric-messages-common.properties"));
            globalProperties = props;
        }
        return globalProperties;
    }
}
