/**
 * 
 */
package paye.eoy.output.mapper;

import java.util.HashMap;
import java.util.Map;

/**
 * This is just a big lookup table to take an XPath and convert it to one of the
 * location strings specified in the Eric Error Response Document. The XPaths
 * usually come from DocumentError instances (which are mapped from XML parser
 * exceptions).
 * 
 * @author Doug Clinton
 * 
 */
public class XPathLocatorMap {

    private static Map<String, String> locatorMap = new HashMap<String, String>();

    public static String mapXPathToLocator(final String xPath) {
        return locatorMap.get(xPath);
    }

    private static String[][] dataTable = {
            { "/IRenvelope/EndOfYearReturn/P35Amended/CessationDate", "Cessation Date" },
            { "/IRenvelope/EndOfYearReturn/P35/CessationDate", "Cessation Date" },

            { "/IRenvelope/IRheader/Agent/Address/Country", "Country" },
            { "/IRenvelope/EndOfYearReturn/P35/EmployerDetails/EmployerAddress/Country", "Country" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/EmployerDetails/EmployerAddress/Country", "Country" },
            { "/IRenvelope/EndOfYearReturn/P14/Address/Country", "P14 Country" },
            { "/IRenvelope/EndOfYearReturn/P14Amended/Address/Country", "P14 Country" },

            { "/IRenvelope/EndOfYearReturn/P14Amended/Address/PostCode", "P14 Post Code" },
            { "/IRenvelope/EndOfYearReturn/P14/Address/PostCode", "P14 Post Code" },
            { "/IRenvelope/EndOfYearReturn/P35/EmployerDetails/EmployerAddress/PostCode", "Post Code" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/EmployerDetails/EmployerAddress/PostCode", "Post Code" },
            { "/IRenvelope/EndOfYearReturn/P14/Name/Sur", "P14 Surname" },
            { "/IRenvelope/EndOfYearReturn/P14Amended/Name/Sur", "P14 Surname" },
            { "/IRenvelope/EndOfYearReturn/CompressedPart", "CompressedPart" },
            { "/IRenvelope/EndOfYearReturn/NumberOfParts", "Number Of Parts" },
            { "/IRenvelope/EndOfYearReturn/P14/NICs/Both", "P14 Total of employee's and employer's contributions payable" },
            { "/IRenvelope/EndOfYearReturn/P14/NICs/Earn/AtLEL",
                    "P14 Earnings at the Lower Earnings Limit (LEL) where earnings reach or exceed the LEL" },
            { "/IRenvelope/EndOfYearReturn/P14/NICs/Earn/ETtoUEL",
                    "P14 Earnings above the ET up to and including the Upper Earnings Limit (UEL)" },
            { "/IRenvelope/EndOfYearReturn/P14/NICs/Earn/LELtoET",
                    "P14 Earnings above the LEL up to and including the earnings threshold (ET)" },
            { "/IRenvelope/EndOfYearReturn/P14/NICs/Emp", "P14 Employee's contributions payable" },
            { "/IRenvelope/EndOfYearReturn/P14/NICs/SCON", "P14 SCON" },
            { "/IRenvelope/EndOfYearReturn/P14/Name/Fore", "P14 Forename" },
            { "/IRenvelope/EndOfYearReturn/P14/Address/Line", "P14 Address" },
            { "/IRenvelope/EndOfYearReturn/P14Amended/Address/Line", "P14 Address" },
            { "/IRenvelope/EndOfYearReturn/P14/PayAndTax/PrevEmp/Tax", "P14 Tax deducted in Previous Employment(s)" },
            { "/IRenvelope/EndOfYearReturn/P14/PayAndTax/PrevEmp/TaxablePay", "P14 Pay in previous employment(s)" },
            { "/IRenvelope/EndOfYearReturn/P14/PayAndTax/ThisEmp/Code", "P14 Final tax code" },
            { "/IRenvelope/EndOfYearReturn/P14/PayAndTax/ThisEmp/EndDate", "P14 Date of leaving" },
            { "/IRenvelope/EndOfYearReturn/P14/PayAndTax/ThisEmp/StLoan", "P14 Student loan deductions in this employment" },
            { "/IRenvelope/EndOfYearReturn/P14/PayAndTax/ThisEmp/Start", "P14 Date of starting" },
            { "/IRenvelope/EndOfYearReturn/P14/PayAndTax/ThisEmp/Tax", "P14 Tax deducted in this employment" },
            { "/IRenvelope/EndOfYearReturn/P14/PayAndTax/ThisEmp/TaxCredit", "P14 Tax Credit" },
            { "/IRenvelope/EndOfYearReturn/P14/PayAndTax/ThisEmp/TaxablePay", "P14 Pay in this employment" },
            { "/IRenvelope/EndOfYearReturn/P14/PayAndTax/ThisEmp/WidOrph", "P14 Widows and Orphans" },
            { "/IRenvelope/EndOfYearReturn/P14/SAP", "P14 Statutory Adoption Pay (SAP)" },
            { "/IRenvelope/EndOfYearReturn/P14/SMP", "P14 Statutory Maternity Pay (SMP)" },
            { "/IRenvelope/EndOfYearReturn/P14/SPP", "P14 Statutory Paternity Pay (SPP)" },
            { "/IRenvelope/EndOfYearReturn/P14/SSP", "P14 Statutory Sick Pay (SSP)" },
            { "/IRenvelope/EndOfYearReturn/P14/Sex", "P14 Employee's gender" },
            { "/IRenvelope/EndOfYearReturn/P14/WkNo", "P14 Works number" },
            { "/IRenvelope/EndOfYearReturn/P14Amended/NICs/Both", "P14 Total of employee's and employer's contributions payable" },
            { "/IRenvelope/EndOfYearReturn/P14Amended/NICs/Earn/AtLEL",
                    "P14 Earnings at the Lower Earnings Limit (LEL) where earnings reach or exceed the LEL" },
            { "/IRenvelope/EndOfYearReturn/P14Amended/NICs/Earn/ETtoUEL",
                    "P14 Earnings above the ET up to and including the Upper Earnings Limit (UEL)" },
            { "/IRenvelope/EndOfYearReturn/P14Amended/NICs/Earn/LELtoET",
                    "P14 Earnings above the LEL up to and including the earnings threshold (ET)" },
            { "/IRenvelope/EndOfYearReturn/P14Amended/NICs/Emp", "P14 Employee's contributions payable" },
            { "/IRenvelope/EndOfYearReturn/P14Amended/NICs/SCON", "P14 SCON" },
            { "/IRenvelope/EndOfYearReturn/P14Amended/Name/Fore", "P14 Forename" },
            { "/IRenvelope/EndOfYearReturn/P14Amended/PayAndTax/PrevEmp/Tax", "P14 Tax deducted in Previous Employment(s)" },
            { "/IRenvelope/EndOfYearReturn/P14Amended/PayAndTax/PrevEmp/TaxablePay", "P14 Pay in previous employment(s)" },
            { "/IRenvelope/EndOfYearReturn/P14Amended/PayAndTax/ThisEmp", "ThisEmp" },
            { "/IRenvelope/EndOfYearReturn/P14Amended/PayAndTax/ThisEmp/Code", "P14 Final tax code" },
            { "/IRenvelope/EndOfYearReturn/P14Amended/PayAndTax/ThisEmp/EndDate", "P14 Date of leaving" },
            { "/IRenvelope/EndOfYearReturn/P14Amended/PayAndTax/ThisEmp/StLoan", "P14 Student loan deductions in this employment" },
            { "/IRenvelope/EndOfYearReturn/P14Amended/PayAndTax/ThisEmp/Start", "P14 Date of starting" },
            { "/IRenvelope/EndOfYearReturn/P14Amended/PayAndTax/ThisEmp/Tax", "P14 Tax deducted in this employment" },
            { "/IRenvelope/EndOfYearReturn/P14Amended/PayAndTax/ThisEmp/TaxCredit", "P14 Tax Credit" },
            { "/IRenvelope/EndOfYearReturn/P14Amended/PayAndTax/ThisEmp/TaxablePay", "P14 Pay in this employment" },
            { "/IRenvelope/EndOfYearReturn/P14Amended/PayAndTax/ThisEmp/WidOrph", "P14 Widows and Orphans" },
            { "/IRenvelope/EndOfYearReturn/P14Amended/SAP", "P14 Statutory Adoption Pay (SAP)" },
            { "/IRenvelope/EndOfYearReturn/P14Amended/SMP", "P14 Statutory Maternity Pay (SMP)" },
            { "/IRenvelope/EndOfYearReturn/P14Amended/SPP", "P14 Statutory Paternity Pay (SPP)" },
            { "/IRenvelope/EndOfYearReturn/P14Amended/SSP", "P14 Statutory Sick Pay (SSP)" },
            { "/IRenvelope/EndOfYearReturn/P14Amended/Sex", "P14 Employee's gender" },
            { "/IRenvelope/EndOfYearReturn/P14Amended/WkNo", "P14 Works number" },
            { "/IRenvelope/EndOfYearReturn/P14Count", "P14 Count" },
            { "/IRenvelope/EndOfYearReturn/P35/CheckList/CompletedEndOfYearSummary", "Q1 - End of year summary" },
            { "/IRenvelope/EndOfYearReturn/P35/CheckList/EmployeesOutOfUK", "Q4 - Employees out of UK" },
            { "/IRenvelope/EndOfYearReturn/P35/CheckList/EmployeesPayToThirdParty", "Q5 - Employees pay to third party" },
            { "/IRenvelope/EndOfYearReturn/P35/CheckList/ExpensesOrBenefits", "Q3 - Expenses or benefits" },
            { "/IRenvelope/EndOfYearReturn/P35/CheckList/FreeOfTaxPayments", "Q2 - Free of tax  payments" },
            { "/IRenvelope/EndOfYearReturn/P35/CheckList/ServicePayments", "Q6 - Service Payments" },
            { "/IRenvelope/EndOfYearReturn/P35/Declarations/P11Ddeclaration", "P11D Declaration" },
            { "/IRenvelope/EndOfYearReturn/P35/Declarations/P14Declaration", "P14 Declaration" },
            { "/IRenvelope/EndOfYearReturn/P35/Declarations/P38Adeclaration", "P38A Declaration" },
            { "/IRenvelope/EndOfYearReturn/P35/EmployerDetails/ECON", "ECON" },
            { "/IRenvelope/EndOfYearReturn/P35/EmployerDetails/EmployerName", "Employer Name" },
            { "/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/CombinedLessStatutoryRecovered",
                    "Combined Amounts LESS NET Statutory Payment Recovered" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/CombinedLessStatutoryRecovered",
                    "Combined Amounts LESS NET Statutory Payment Recovered" },
            { "/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/CISdeductions", "CIS deductions suffered" },
            { "/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/IncentivePayment", "Incentive Payment" },
            { "/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/NetDeductions", "Total net deductions" },
            { "/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/NetStatutoryPaymentsRecovered",
                    "Net statutory payments recovered" },
            { "/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/NetTaxCredits", "Net Tax Credits" },
            { "/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/StudentLoan", "Total student loan deductions" },
            { "/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/TaxCredit", "Tax Credit" },
            { "/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/TaxCreditFunding",
                    "Funding received from HMRC to pay tax credits" },
            { "/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/TotalAfterCISdeductions", "Revised amount now payable" },
            { "/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/TotalNICsTaxAndStudentLoan",
                    "Total NIC/Tax and student loan" },
            { "/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/TotalPaid", "NIC/Tax paid already" },
            { "/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/TotalPayable", "Amount payable for the year" },
            { "/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/TotalRemainingToPay", "Now payable" },
            { "/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/TotalTaxAndNIC", "Total tax and NIC" },
            { "/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SAP", "SAP recovered" },
            { "/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SAPcompensation", "NIC compensation on SAP" },
            { "/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SMP", "SMP recovered" },
            { "/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SMPcompensation", "NIC compensation on SMP" },
            { "/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SPP", "SPP recovered" },
            { "/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SPPcompensation", "NIC compensation on SPP" },
            { "/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SSP", "SSP recovered" },
            { "/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SSPSMPSPPandSAPfunding",
                    "Funding Received from HMRC to Pay SSP/SMP/SPP/SAP" },
            { "/IRenvelope/EndOfYearReturn/P35/Summary/NIC/OSPPcompensation", "NIC compensation on OSPP" },
            { "/IRenvelope/EndOfYearReturn/P35/Summary/NIC/OSSP", "OSSP recovered" },
            { "/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SSPSMPOSPPASPPandSAPfunding",
                    "Funding Received from HMRC to Pay SSP/SMP/OSPP/ASPP/SAP" },
            { "/IRenvelope/EndOfYearReturn/P35/Summary/NIC/TotalNIC", "Total NIC" },
            { "/IRenvelope/EndOfYearReturn/P35/Summary/PAYE/P14Tax", "Total tax from P14s" },
            { "/IRenvelope/EndOfYearReturn/P35/Summary/PAYE/SubcontractorTax", "Deductions made from subcontractors" },
            // Subcontractor tax moved in 0607
            { "/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/SubcontractorTax", "Deductions made from subcontractors" },
            { "/IRenvelope/EndOfYearReturn/P35/Summary/PAYE/TaxAdvance", "Advance received from HMRC to refund tax" },
            { "/IRenvelope/EndOfYearReturn/P35/Summary/PAYE/TotalTax", "Total Tax" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/CheckList/CompletedEndOfYearSummary", "Q1 - End of year summary" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/CheckList/EmployeesOutOfUK", "Q4 - Employees out of UK" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/CheckList/EmployeesPayToThirdParty", "Q5 - Employees pay to third party" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/CheckList/ExpensesOrBenefits", "Q3 - Expenses or benefits" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/CheckList/FreeOfTaxPayments", "Q2 - Free of tax  payments" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/CheckList/ServicePayments", "Q6 - Service Payments" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/Declarations/P11Ddeclaration", "P11D Declaration" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/Declarations/P14Declaration", "P14 Declaration" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/Declarations/P38Adeclaration", "P38A Declaration" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/EmployerDetails/ECON", "ECON" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/EmployerDetails/EmployerName", "Employer Name" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/CISdeductions", "CIS deductions suffered" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/IncentivePayment", "Incentive Payment" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/NetDeductions", "Total net deductions" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/NetStatutoryPaymentsRecovered",
                    "Net statutory payments recovered" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/NetTaxCredits", "Net Tax Credits" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/StudentLoan", "Total student loan deductions" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/TaxCredit", "Tax Credit" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/TaxCreditFunding",
                    "Funding received from HMRC to pay tax credits" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/TotalAfterCISdeductions",
                    "Revised amount now payable" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/TotalNICsTaxAndStudentLoan",
                    "Total NIC/Tax and student loan" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/TotalPaid", "NIC/Tax paid already" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/TotalPayable", "Amount payable for the year" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/TotalRemainingToPay", "Now payable" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/TotalTaxAndNIC", "Total tax and NIC" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/SAP", "SAP recovered" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/SAPcompensation", "NIC compensation on SAP" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/SMP", "SMP recovered" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/SMPcompensation", "NIC compensation on SMP" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/SPP", "SPP recovered" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/SPPcompensation", "NIC compensation on SPP" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/SSP", "SSP recovered" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/SSPSMPSPPandSAPfunding",
                    "Funding received from HMRC to pay SSP/SMP/SPP/SAP" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/TotalNIC", "Total NIC" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/Summary/PAYE/P14Tax", "Total tax from P14s" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/Summary/PAYE/SubcontractorTax", "Deductions made from subcontractors" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/SubcontractorTax",
                    "Deductions made from subcontractors" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/Summary/PAYE/TaxAdvance", "Advance received from HMRC to refund tax" },
            { "/IRenvelope/EndOfYearReturn/P35Amended/Summary/PAYE/TotalTax", "Total Tax" },
            { "/IRenvelope/EndOfYearReturn/PartTotals/P14Count", "P14  Count" },
            { "/IRenvelope/EndOfYearReturn/PartTotals/P14Count", "Total number of P14s submitted" },
            { "/IRenvelope/EndOfYearReturn/PartTotals/TotalContributions", "Total of employee's and employer's contributions" },
            { "/IRenvelope/EndOfYearReturn/PartTotals/TotalSAP", "Total of SAP" },
            { "/IRenvelope/EndOfYearReturn/PartTotals/TotalSMP", "Total of SMP" },
            { "/IRenvelope/EndOfYearReturn/PartTotals/TotalSPP", "Total of SPP" },
            { "/IRenvelope/EndOfYearReturn/PartTotals/TotalSSP", "Total of SSP" },
            { "/IRenvelope/EndOfYearReturn/PartTotals/TotalStudentLoanDeductions", "Total of student loan deductions" },
            { "/IRenvelope/EndOfYearReturn/PartTotals/TotalTax", "Total Tax" },
            { "/IRenvelope/EndOfYearReturn/PartTotals/TotalTaxCredits", "Total of tax credits" },
            { "/IRenvelope/EndOfYearReturn/PartTotalsAmended/P14Count", "P14  Count" },
            { "/IRenvelope/EndOfYearReturn/PartTotalsAmended/P14Count", "Total number of P14s submitted" },
            { "/IRenvelope/EndOfYearReturn/PartTotalsAmended/TotalContributions",
                    "Total of employee's and employer's contributions" },
            { "/IRenvelope/EndOfYearReturn/PartTotalsAmended/TotalSAP", "Total of SAP" },
            { "/IRenvelope/EndOfYearReturn/PartTotalsAmended/TotalSMP", "Total of SMP" },
            { "/IRenvelope/EndOfYearReturn/PartTotalsAmended/TotalSPP", "Total of SPP" },
            { "/IRenvelope/EndOfYearReturn/PartTotalsAmended/TotalSSP", "Total of SSP" },
            { "/IRenvelope/EndOfYearReturn/PartTotalsAmended/TotalStudentLoanDeductions", "Total of student loan deductions" },
            { "/IRenvelope/EndOfYearReturn/PartTotalsAmended/TotalTax", "Total Tax" },
            { "/IRenvelope/EndOfYearReturn/PartTotalsAmended/TotalTaxCredits", "Total of tax credits" },
            { "/IRenvelope/EndOfYearReturn/ReturnType", "Return Type" },
            { "/IRenvelope/EndOfYearReturn/SubmissionType", "Submission Type" },
            { "/IRenvelope/EndOfYearReturn/UniqueID", "UniqueID" }, { "/IRenvelope/IRheader/PeriodEnd", "Period End" }, };

    static {
        for (final String[] element : dataTable) {
            locatorMap.put(element[0], element[1]);
        }
    }
}
