/**
 * 
 */
package paye.eoy.output.mapper.generic;

import paye.eoy.output.mapper.XPathLocatorMap;
import processingError.ProcessingError;
import bizrules.BusinessRuleError;
import ericResponse.output.translator.genericerror.GenericErrorMapper;

/**
 * @author Doug Clinton
 * 
 */
public abstract class AbstractGenericErrorDetailMapper implements GenericErrorMapper {

    protected String getLocationString(final ProcessingError pe) {
        String locationString = null;

        /**
         * Arrgh! All the ProcessingError stuff is a complete mess, including
         * trying to determine the location of an error. Really needs a big
         * overhaul.
         */
        if (pe.getLocation() != null) {
            final String tagName = pe.getLocation().getTagName();

            locationString = XPathLocatorMap.mapXPathToLocator(tagName);
            if (locationString == null && pe instanceof BusinessRuleError) {
                locationString = tagName;
            }

            if (locationString == null) {
                locationString = "LineNumber:'" + pe.getLocation().getLineNumber() + "', XPath:'" + tagName + "'";
            }
        } else {
            locationString = pe.getRuleName();
        }

        return locationString;
    }
}
