/*
 * Created on 02-Jan-2006
 *
 * $Id: BlankElement5016Factory.java,v 1.8 2006/08/10 15:19:11 dec Exp $
 */
package paye.eoy.output.mapper.generic;

import processingError.ProcessingError;
import xmldoc.DocumentError;
import ericResponse.output.error.ERErrorDetail;

/**
 * Catches errors with a subcode of "blank" and maps them to the generic 5106
 * response message.
 * 
 */
public class BlankElement5016Mapper extends AbstractGenericErrorDetailMapper {

    public boolean isApplicable(final ProcessingError pe) {
        return pe.getSubCode().equals(DocumentError.BLANK);
    }

    public ERErrorDetail mapProcessingError(final ProcessingError pe) {
        final ERErrorDetail detail = new ERErrorDetail();
        detail.setMessageText("Entry required.");
        detail.setLocator(getLocationString(pe));
        detail.setCode("5016");
        return detail;
    }
}
